/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.template;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.ExceptionUtils;
import com.rocogz.common.util.ReqUtils;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseSingleTemplate<Request, Result> {
    private static final Logger log = LoggerFactory.getLogger(BaseSingleTemplate.class);
    @Autowired
    private Validator validator;

    public CommonResponse<Result> call(CommonRequest<Request> request) {
        try {
            Class[] groups = this.setCheckGroups();
            ExceptionUtils.valid(this.validator, request, groups);
            Result result = this.callInner(request);
            return CommonResponse.success(result);
        }
        catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    protected abstract Result callInner(CommonRequest<Request> var1) throws Exception;

    protected Class[] setCheckGroups() {
        return new Class[0];
    }

    public Result callService(CommonRequest commonRequest, Request request) throws Exception {
        Class[] groups = this.setCheckGroups();
        log.info("callService: req [{}]", request, (Object)groups);
        ExceptionUtils.valid(this.validator, request, new Class[0]);
        CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
        Result result = this.callInner(innerReq);
        log.info("callService: res [{}]", result);
        return result;
    }
}

