package com.rocogz.common.template.api;

import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.util.TemplateUtils;

/**
 * @author Andrew
 * @create 2020/9/4 9:53 上午
 */
public interface BasePageApi<Request, Response> extends BaseTemplateApi {
    
    
    /**
     * 调用方法
     * @param request
     * @return
     */
    default CommonQueryPageResponse<Response> call(CommonQueryPageRequest<Request> request) {
        return TemplateUtils.invoke(this, request);
    }
    
    
    /**
     * 内部实现
     * @param request
     * @return
     * @throws Exception
     */
    PageSerializable<Response> callInner(CommonQueryPageRequest<Request> request) throws Exception;
    
}
