package com.rocogz.common.util;

import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.exception.ParamException;
import com.rocogz.common.template.api.BasePageApi;
import com.rocogz.common.template.api.BaseSingleApi;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import java.util.Set;

/**
 * @author Andrew
 * @create 2020/9/4 9:46 上午
 */
public class TemplateUtils implements ApplicationContextAware {
    private static Validator validator;
    
    public static CommonResponse invoke(BaseSingleApi api, CommonRequest request) {
        try {
            valid(api.setCheckGroups(), request);
            return CommonResponse.success(api.callInner(request));
        } catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }
    
    public static CommonQueryPageResponse invoke(BasePageApi api, CommonQueryPageRequest request) {
        try {
            valid(api.setCheckGroups(), request);
            PageSerializable pageInfo = api.callInner(request);
            return CommonQueryPageResponse.success(pageInfo.getList(), pageInfo.getTotal(), getPages(pageInfo.getTotal(), request));
        } catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }
    
    private static int getPages(long total, CommonQueryPageRequest request) {
        int pageSize = request.getPageSize();
        return (int) (total / (long) pageSize + (long) (total % (long) pageSize == 0L ? 0 : 1));
    }
    
    public static void valid(Class[] groups, CommonRequest request) {
        Set<ConstraintViolation<Object>> set = validator.validate(request, groups);
        if (!CollectionUtils.isEmpty(set)) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation v : set) {
                msg.append(v.getPropertyPath()).append(":").append(v.getMessage()).append(",");
            }
            msg.delete(msg.length() - 1, msg.length());
            throw new ParamException(msg.toString());
        }
    }
    
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        validator = applicationContext.getBean(Validator.class);
    }
}
