/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.dubbo.filter;

import cn.hutool.core.util.ReflectUtil;
import com.google.common.collect.Sets;
import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.util.RpcContextUtils;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    private static final String TOTAL = "*";
    private static final String SPLIT = ",";
    private static final String SET_CODE = "code";
    private static final String SET_MESSAGE = "message";

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String auth = RpcContextUtils.getAuth();
        if (StringUtils.isNotBlank((CharSequence)auth)) {
            log.info("auth:{}", (Object)auth);
            Set<String> permissions = RpcContextUtils.getPermissions();
            if (!permissions.contains(TOTAL) && !permissions.containsAll(Sets.newHashSet((Object[])auth.split(SPLIT))) && invocation instanceof RpcInvocation) {
                RpcInvocation rpcInvocation = (RpcInvocation)invocation;
                try {
                    Object resp = rpcInvocation.getReturnType().newInstance();
                    ReflectUtil.setFieldValue(resp, (String)SET_CODE, (Object)ResponseEnum.AUTH_ERROR.getCode());
                    ReflectUtil.setFieldValue(resp, (String)SET_MESSAGE, (Object)ResponseEnum.AUTH_ERROR.getMessage());
                    return AsyncRpcResult.newDefaultAsyncResult(resp, (Invocation)invocation);
                }
                catch (Exception e) {
                    throw new RpcException(Integer.valueOf(ResponseEnum.AUTH_ERROR.getCode()).intValue(), ResponseEnum.AUTH_ERROR.getMessage(), (Throwable)e);
                }
            }
        }
        return invoker.invoke(invocation);
    }
}

