/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.dubbo.filter;

import com.alibaba.fastjson.JSON;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GenericConvertFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GenericConvertFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object[] params = invocation.getArguments();
        if (params != null && params.length == 1) {
            Object param = params[0];
            Object newParam = null;
            try {
                if (param instanceof CommonRequest) {
                    newParam = this.getConvertReq((CommonRequest)param);
                } else if (param instanceof CommonQueryPageRequest) {
                    newParam = this.getConvertReq((CommonQueryPageRequest)param);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u63a5\u53e3\u914d\u7f6e\u5f02\u5e38", e);
            }
            if (newParam != null) {
                RpcInvocation rpcInvocation = new RpcInvocation(invocation);
                rpcInvocation.setArguments(new Object[]{param});
                return invoker.invoke((Invocation)rpcInvocation);
            }
        }
        return invoker.invoke(invocation);
    }

    private Object getConvertReq(CommonRequest commonRequest) throws Exception {
        Object request = commonRequest.getRequest();
        if (request != null && request instanceof HashMap) {
            commonRequest.setRequest(this.getConvertReq((HashMap)request));
            return commonRequest;
        }
        return null;
    }

    private Object getConvertReq(CommonQueryPageRequest commonRequest) throws Exception {
        Object request = commonRequest.getRequest();
        if (request != null && request instanceof HashMap) {
            commonRequest.setRequest(this.getConvertReq((HashMap)request));
            return commonRequest;
        }
        return null;
    }

    private Object getConvertReq(Map<String, Object> reqMap) throws Exception {
        Object clazz = reqMap.get("class");
        log.info("Convert:{}", clazz);
        Assert.notNull((Object)clazz, (String)"\u63a5\u53e3\u914d\u7f6e\u9519\u8bef");
        Object reqParam = reqMap.get("reqJson");
        Assert.notNull((Object)reqParam, (String)"\u8bf7\u6c42\u9519\u8bef");
        String reqJson = reqParam.toString();
        Object newReq = JSON.parseObject((String)reqJson, Class.forName(clazz.toString()));
        return newReq;
    }
}

