/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.service;

import com.rocogz.common.service.CallBackAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionCallBackService {
    private static final Logger log = LoggerFactory.getLogger(TransactionCallBackService.class);

    public void afterCommit(final CallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    log.info("\u4e8b\u52a1\u63d0\u4ea4\u540e\u6267\u884c");
                    action.callback();
                }
            });
        } else {
            log.info("\u5f53\u524d\u6ca1\u6709\u4e8b\u52a1\uff0c\u76f4\u63a5\u6267\u884c");
            action.callback();
        }
    }

    public void afterRollback(final CallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    if (1 == status) {
                        log.info("\u4e8b\u52a1\u56de\u6eda\u540e\u6267\u884c");
                        action.callback();
                    }
                }
            });
        } else {
            log.info("\u5f53\u524d\u6ca1\u6709\u4e8b\u52a1\u6267\u884c");
            action.callback();
        }
    }
}

