/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.template;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.template.api.BaseSingleApi;
import com.rocogz.common.util.ReqUtils;
import com.rocogz.common.util.TemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseTransactionalTemplate<Request, Result>
implements BaseSingleApi<Request, Result> {
    private static final Logger log = LoggerFactory.getLogger(BaseTransactionalTemplate.class);

    @Override
    public CommonResponse<Result> call(CommonRequest<Request> request) {
        Object proxy = AopContext.currentProxy();
        return TemplateUtils.invoke((BaseTransactionalTemplate)proxy, request);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public abstract Result callInner(CommonRequest<Request> var1) throws Exception;

    @Override
    public Result callService(CommonRequest commonRequest, Request request) throws Exception {
        CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
        TemplateUtils.valid(this.setCheckGroups(), innerReq);
        Object proxy = AopContext.currentProxy();
        Result result = ((BaseTransactionalTemplate)proxy).callInner(innerReq);
        return result;
    }
}

