/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.util;

import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.exception.ParamException;
import com.rocogz.common.template.api.BasePageApi;
import com.rocogz.common.template.api.BaseSingleApi;
import com.rocogz.common.util.ExceptionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class TemplateUtils
implements ApplicationContextAware {
    private static Validator validator;

    public static CommonResponse invoke(BaseSingleApi api, CommonRequest request) {
        try {
            TemplateUtils.valid(api.setCheckGroups(), request);
            return CommonResponse.success(api.callInner(request));
        }
        catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    public static CommonQueryPageResponse invoke(BasePageApi api, CommonQueryPageRequest request) {
        try {
            TemplateUtils.valid(api.setCheckGroups(), (CommonRequest)request);
            PageSerializable pageInfo = api.callInner(request);
            return CommonQueryPageResponse.success((List)pageInfo.getList(), (long)pageInfo.getTotal(), (int)TemplateUtils.getPages(pageInfo.getTotal(), request));
        }
        catch (Exception e) {
            return ExceptionUtils.handle(request, e);
        }
    }

    private static int getPages(long total, CommonQueryPageRequest request) {
        int pageSize = request.getPageSize();
        return (int)(total / (long)pageSize + (long)(total % (long)pageSize == 0L ? 0 : 1));
    }

    public static void valid(Class[] groups, CommonRequest request) {
        Set set = validator.validate((Object)request, groups);
        if (!CollectionUtils.isEmpty((Collection)set)) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation v : set) {
                msg.append(v.getPropertyPath()).append(":").append(v.getMessage()).append(",");
            }
            msg.delete(msg.length() - 1, msg.length());
            throw new ParamException(msg.toString());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        validator = (Validator)applicationContext.getBean(Validator.class);
    }
}

