package com.rocogz.common.dubbo.filter;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.rocogz.common.api.request.CommonRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;

import java.util.HashMap;
import java.util.Map;

/**
 * 泛化调用转换对象过滤器
 *
 * @author Andrew
 * @create 2020/2/18 5:22 下午
 */
@Slf4j
public class GenericConvertFilter implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object[] params = invocation.getArguments();
        if (params != null && params.length == 1) {
            Object param = params[0];
            Object newParam = null;
            if (param instanceof CommonRequest) {
                newParam = getConvertReq((CommonRequest) param);
            }
            if (newParam != null) {
                RpcInvocation rpcInvocation = new RpcInvocation(invocation);
                rpcInvocation.setArguments(new Object[]{param});
                return invoker.invoke(rpcInvocation);
            }
        }
        return invoker.invoke(invocation);
    }
    
    
    private Object getConvertReq(CommonRequest commonRequest) {
        Object request = commonRequest.getRequest();
        if (request != null && request instanceof HashMap) {
            commonRequest.setRequest(getConvertReq((HashMap) request));
            return commonRequest;
        }
        return null;
    }
    
    
    private Object getConvertReq(Map<String, Object> reqMap) {
        Object clazz = reqMap.get("class");
        log.info("Convert:{}", clazz);
        Assert.notNull(clazz, "接口配置错误");
        
        Object reqParam = reqMap.get("reqJson");
        Assert.notNull(reqParam, "请求错误");
        
        String reqJson = reqParam.toString();
        
        Object newReq = null;
        try {
            newReq = JSON.parseObject(reqJson, Class.forName(clazz.toString()));
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("错误的类路径:%s", clazz.toString()));
        }
        
        return newReq;
    }
}
