package com.rocogz.common.template;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.template.api.BasePageApi;
import lombok.extern.slf4j.Slf4j;

import java.util.List;


/**
 * 分页查询服务模版
 * @param <Request> 请求
 * @param <DO> 对应数据库DO
 * @author Andrew
 * @create 2020/2/5 10:04 上午
 */
@Slf4j
public abstract class BaseQueryPageTemplate<Request, DO> implements BasePageApi<Request, DO> {

    
    @Override
    public PageSerializable<DO> callInner(CommonQueryPageRequest<Request> request) throws Exception {
        PageHelper.startPage(request.getPageNum(), request.getPageSize());
        List<DO> list = query(request);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }
    
    /**
     * 查询数据库
     * @param request
     * @return
     * @throws Exception
     */
    protected abstract List<DO> query(CommonQueryPageRequest<Request> request) throws Exception;
    
}
