package com.rocogz.common.template;


import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.api.BaseSingleApi;
import lombok.extern.slf4j.Slf4j;

/**
 * 单个服务模版
 *
 * @param <Request> 请求
 * @param <Result>  结果
 * @author Andrew
 * @create 2020/2/5 10:04 上午
 */
@Slf4j
public abstract class BaseSingleTemplate<Request, Result> implements BaseSingleApi<Request, Result> {
    /**
     * 调用内部服务的方法
     *
     * @param request
     * @return
     * @throws Exception
     */
    @Override
    public abstract Result callInner(CommonRequest<Request> request) throws Exception;
    
}
