package com.rocogz.common.template;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.template.api.BasePageApi;
import lombok.extern.slf4j.Slf4j;

import java.util.List;


/**
 * 分页查询服务模版
 *
 * @param <Request> 请求
 * @param <Result>  响应
 * @author Andrew
 * @create 2020/2/5 10:04 上午
 */
@Slf4j
public abstract class BaseTransitionQueryPageTemplate<Request, Result, QueryRequest, DO> implements BasePageApi<Request, Result> {
    
    @Override
    public PageSerializable<Result> callInner(CommonQueryPageRequest<Request> request) throws Exception {
        QueryRequest transReq = transformRequest(request.getRequest());
        PageHelper.startPage(request.getPageNum(), request.getPageSize());
        List<DO> list = query(CommonQueryPageRequest.build(transReq, request.getPageNum(), request.getPageSize()));
        PageInfo pageInfo = new PageInfo(list);
        PageSerializable<Result> pageSerializable = new PageSerializable();
        pageSerializable.setTotal(pageInfo.getTotal());
        pageSerializable.setList(transformerResponse(list));
        return pageSerializable;
    }
    
    
    /**
     * 查询数据库
     *
     * @param request
     * @return
     * @throws Exception
     */
    protected abstract List<DO> query(CommonQueryPageRequest<QueryRequest> request) throws Exception;
    
    /**
     * 转换请求
     *
     * @param req
     * @return 转换请求对象
     */
    protected abstract QueryRequest transformRequest(Request req);
    
    
    /**
     * 转换响应
     *
     * @param resp
     * @return 转换后的结果
     */
    protected abstract List<Result> transformerResponse(List<DO> resp);
    
}
