package com.rocogz.common.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/**
 * @author Andrew
 * @create 2020/8/13 9:18 上午
 */
@Slf4j
public class TransactionCallBackService {
    
    
    /**
     * 事务提交后
     *
     * @param action
     */
    public void afterCommit(final CallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager
                    .registerSynchronization(new TransactionSynchronizationAdapter() {
                        @Override
                        public void afterCommit() {
                            // 事务提交后执行回调
                            log.info("事务提交后执行");
                            action.callback();
                        }
                        
                        
                    });
        }  else {
            throw new RuntimeException("当前没有事务");
        }
    }
    
    
    /**
     * 事务回滚后
     *
     * @param action
     */
    public void afterRollback(final CallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager
                    .registerSynchronization(new TransactionSynchronizationAdapter() {
                        @Override
                        public void afterCompletion(int status) {
                            if (TransactionSynchronization.STATUS_ROLLED_BACK == status) {
                                log.info("事务回滚后执行");
                                action.callback();
                            }
                        }
                    });
        } else {
            throw new RuntimeException("当前没有事务");
        }
    }
    
}
