package com.rocogz.common.template;


import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.template.api.BaseSingleApi;
import com.rocogz.common.util.ReqUtils;
import com.rocogz.common.util.TemplateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.framework.AopContext;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 事务模板
 *
 * @author Andrew
 * @create 2020/2/21 2:52 下午
 */
@Slf4j
public abstract class BaseTransactionalTemplate<Request, Result> implements BaseSingleApi<Request, Result> {
    
    
    @Override
    public CommonResponse<Result> call(CommonRequest<Request> request) {
        Object proxy = AopContext.currentProxy();
        return TemplateUtils.invoke(((BaseTransactionalTemplate) proxy), request);
    }
    
    /**
     * 调用内部服务的方法
     *
     * @param request
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRED)
    public abstract Result callInner(CommonRequest<Request> request) throws Exception;
    
    
    @Override
    public Result callService(CommonRequest commonRequest, Request request) throws Exception {
        CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
        TemplateUtils.valid(setCheckGroups(), innerReq);
        Object proxy = AopContext.currentProxy();
        Result result = (Result) ((BaseTransactionalTemplate)proxy).callInner(innerReq);
        return result;
    }
    
    
}
