package com.rocogz.common.template.api;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.common.util.ReqUtils;
import com.rocogz.common.util.TemplateUtils;

/**
 * @author Andrew
 * @create 2020/9/4 9:53 上午
 */
public interface BaseSingleApi<Request, Response> extends BaseTemplateApi {
    
    
    /**
     * 调用方法
     * @param request
     * @return
     */
    default CommonResponse<Response> call(CommonRequest<Request> request) {
        return TemplateUtils.invoke(this, request);
    }
    
    
    /**
     * 内部实现
     * @param request
     * @return
     * @throws Exception
     */
    Response callInner(CommonRequest<Request> request) throws Exception;
    
    
    /**
     * 内部service调用
     * @param commonRequest
     * @param request
     * @return
     * @throws Exception
     */
     default Response callService(CommonRequest commonRequest, Request request) throws Exception {
         CommonRequest<Request> innerReq = ReqUtils.converterReq(commonRequest, request);
         TemplateUtils.valid(setCheckGroups(), innerReq);
         Response result = callInner(innerReq);
         return result;
     }
    
}
