package com.rocogz.common.util;


import cn.hutool.core.util.ReflectUtil;
import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.dto.ErrorResult;
import com.rocogz.common.exception.BizException;
import com.rocogz.common.exception.ParamException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DuplicateKeyException;

/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Slf4j
public class ExceptionUtils {

    
    public static <T> T handle(CommonRequest request, Exception e, Class<T> respClass) {
        try {
            ErrorResult result = handleException(request, e);
            T resp = respClass.newInstance();
            ReflectUtil.setFieldValue(resp, "code", result.getCode());
            ReflectUtil.setFieldValue(resp, "message", result.getMessage());
            ReflectUtil.setFieldValue(resp, "result", result.getData());
            return resp;
        } catch (Exception ex) {
            log.error("封装异常", ex);
            throw new RuntimeException(e);
        }
    }

    
    private static ErrorResult handleException(CommonRequest req, Exception e) {
        String code = null;
        String message = null;
        Object data = null;
        if (e instanceof IllegalArgumentException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof ParamException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof DuplicateKeyException) {
            log.error("唯一索引: req[{}]", req, ResponseEnum.DUPLICATE_ERROR.getMessage(), e);
            code = ResponseEnum.DUPLICATE_ERROR.getCode();
            message = ResponseEnum.DUPLICATE_ERROR.getMessage();
        } else if (e instanceof BizException) {
            log.error("业务异常: req[{}]", req, e);
            code = ResponseEnum.BIZ_ERROR.getCode();
            message = e.getMessage();
            data = ((BizException) e).getData();
        } else {
            code = ResponseEnum.SYSTEM_ERROR.getCode();
            message = e.getMessage() == null ? e.toString() : e.getMessage();
            log.error("系统异常: req[{}]:", req, e);
        }
        return new ErrorResult(code, message, data);
    }
    
}
