/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.util;

import cn.hutool.core.util.ReflectUtil;
import com.rocogz.common.api.enums.ResponseEnum;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.dto.ErrorResult;
import com.rocogz.common.exception.BizException;
import com.rocogz.common.exception.ParamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public static <T> T handle(CommonRequest request, Exception e, Class<T> respClass) {
        try {
            ErrorResult result = ExceptionUtils.handleException(request, e);
            T resp = respClass.newInstance();
            ReflectUtil.setFieldValue(resp, (String)"code", (Object)result.getCode());
            ReflectUtil.setFieldValue(resp, (String)"message", (Object)result.getMessage());
            ReflectUtil.setFieldValue(resp, (String)"result", (Object)result.getData());
            return resp;
        }
        catch (Exception ex) {
            log.error("\u5c01\u88c5\u5f02\u5e38", (Throwable)ex);
            throw new RuntimeException(e);
        }
    }

    private static ErrorResult handleException(CommonRequest req, Exception e) {
        String code = null;
        String message = null;
        Object data = null;
        if (e instanceof IllegalArgumentException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof ParamException) {
            code = ResponseEnum.PARAM_ERROR.getCode();
            message = e.getMessage();
        } else if (e instanceof DuplicateKeyException) {
            log.error("\u552f\u4e00\u7d22\u5f15: req[{}]", new Object[]{req, ResponseEnum.DUPLICATE_ERROR.getMessage(), e});
            code = ResponseEnum.DUPLICATE_ERROR.getCode();
            message = ResponseEnum.DUPLICATE_ERROR.getMessage();
        } else if (e instanceof BizException) {
            log.error("\u4e1a\u52a1\u5f02\u5e38: req[{}]", (Object)req, (Object)e);
            code = ResponseEnum.BIZ_ERROR.getCode();
            message = e.getMessage();
            data = ((BizException)e).getData();
        } else {
            code = ResponseEnum.SYSTEM_ERROR.getCode();
            message = e.getMessage() == null ? e.toString() : e.getMessage();
            log.error("\u7cfb\u7edf\u5f02\u5e38: req[{}]:", (Object)req, (Object)e);
        }
        return new ErrorResult(code, message, data);
    }
}

