/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.order.constant.EvaluateStatisOption;
import com.rocogz.syy.order.constant.OrderStatisOption;
import com.rocogz.syy.order.constant.OrderStatisWayEnum;
import com.rocogz.syy.order.constant.OtherInfoOption;
import com.rocogz.syy.order.constant.trace.BussiSystemEnum;
import com.rocogz.syy.order.constant.trace.BussiTypeEnum;
import com.rocogz.syy.order.constant.trace.CallApiEnum;
import com.rocogz.syy.order.dto.AdminSearchParamDto;
import com.rocogz.syy.order.dto.OrderSummaryStatistic;
import com.rocogz.syy.order.dto.OrderWriteOffDto;
import com.rocogz.syy.order.dto.evaluate.AdminSearchEvaluationParamDto;
import com.rocogz.syy.order.dto.evaluate.OrderEvaluateSummaryStatistic;
import com.rocogz.syy.order.dto.oil.DepositSummaryStatistic;
import com.rocogz.syy.order.dto.oil.OilAdminSearchParamDto;
import com.rocogz.syy.order.dto.oil.OilOrderCreateDto;
import com.rocogz.syy.order.dto.oil.OilOrderPayDto;
import com.rocogz.syy.order.dto.oil.OilOrderPayedResultDto;
import com.rocogz.syy.order.entity.evaluate.OrderEvaluate;
import com.rocogz.syy.order.entity.oil.OilDepositRecord;
import com.rocogz.syy.order.entity.oil.OrderOilDeposit;
import com.rocogz.syy.order.entity.orders.OrderLog;
import com.rocogz.syy.order.entity.orders.OrderPayment;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.entity.trace.OrderErrorTrace;
import com.rocogz.syy.order.entity.trace.OrderThirdTrace;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOrderClientService {
    @PostMapping(value={"/api/order/create"})
    public Response createOrder(@RequestBody SaleOrder var1);

    @GetMapping(value={"/api/order/adminSearch"})
    public PageTable<SaleOrder> adminSearch(@SpringQueryMap AdminSearchParamDto var1);

    @GetMapping(value={"/api/order/oil/adminSearch"})
    public PageTable<SaleOrder> adminOilOrderSearch(@SpringQueryMap OilAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/oil/getOrderOilInfo/{orderCode}"})
    public Response<SaleOrder> getOrderOilInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOrderOilPaymentInfo/{orderCode}"})
    public Response<OrderPayment> getOrderOilPaymentInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOrderOilPaymentLogList/{orderCode}"})
    public Response<OrderPayment> getOrderOilPaymentLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOilDepositRecordList/{orderCode}"})
    public Response<List<OilDepositRecord>> getOilDepositRecordList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderMainInfo/{orderCode}"})
    public Response<SaleOrder> getOrderMainInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderWithOtherInfo/{orderCode}"})
    public Response<SaleOrder> getOrderWithOtherInfo(@PathVariable(value="orderCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/weappSearch"})
    public PageTable<SaleOrder> weappSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="limit", defaultValue="10") Integer var3, @RequestParam(value="page", defaultValue="1") Integer var4);

    @GetMapping(value={"/api/order/merchantWeappSearch"})
    public PageTable<SaleOrder> merchantWeappSearch(@RequestParam(value="storeCode") String var1, @RequestParam(value="keyword", required=false) String var2, @RequestParam(value="statusList", required=false) List<String> var3, @RequestParam(value="limit", defaultValue="10") Integer var4, @RequestParam(value="page", defaultValue="1") Integer var5);

    @GetMapping(value={"/api/order/delete/{orderCode}"})
    public Response<String> deleteLogical(@PathVariable(value="orderCode") String var1, @RequestParam(value="userCode", required=false) String var2);

    @GetMapping(value={"/api/order/log/{orderCode}"})
    public Response<List<OrderLog>> findLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/statis/countGroupByStatus"})
    public Response<Map<String, Long>> countOrderNumGroupByStatus(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(value="userCode", required=false) String var2);

    @PostMapping(value={"/api/order/statis/summarize"})
    public Response<Map<OrderStatisWayEnum, OrderSummaryStatistic>> summarizeOrderByStoreCode(@RequestBody List<OrderStatisOption> var1);

    @PostMapping(value={"/api/order/writeOff/validateBeforeWriteOff"})
    public Response<String> validateBeforeWriteOff(@RequestBody OrderWriteOffDto var1);

    @PostMapping(value={"/api/order/writeOff/createOrder"})
    public Response<SaleOrder> createOrderWhenWriteOff(@RequestBody OrderWriteOffDto var1);

    @PostMapping(value={"/api/order/writeOff/updateOrderStatus"})
    public Response<String> updateStatusWithSaveLog(@RequestBody List<OrderLog> var1);

    @PostMapping(value={"/api/order/evaluate/create"})
    public Response<OrderEvaluate> createEvaluate(@RequestBody OrderEvaluate var1);

    @GetMapping(value={"/api/order/evaluate/{orderCode}"})
    public Response<OrderEvaluate> getEvaluateByOrderCode(@PathVariable(value="orderCode") String var1, @RequestParam(value="loadOtherFlag", required=false) Integer var2);

    @GetMapping(value={"/api/order/evaluate/delete/{orderCode}"})
    public Response<String> deleteEvaluate(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/togglePerfect/{orderCode}"})
    public Response<String> toggleEvaluatePerfect(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/toggleVisibility/{orderCode}"})
    public Response<String> toggleEvaluateVisibility(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/adminSearch"})
    public PageTable<OrderEvaluate> adminSearchEvaluation(@SpringQueryMap AdminSearchEvaluationParamDto var1);

    @GetMapping(value={"/api/order/evaluate/weappSearch"})
    public PageTable<OrderEvaluate> weappSearchEvaluation(@RequestParam(value="code", required=false) String var1, @RequestParam(value="statisWay", required=false) EvaluateStatisOption.EvaluateStatisWay var2, @RequestParam(value="visible", required=false) Boolean var3, @RequestParam(value="perfect", required=false) Boolean var4, @RequestParam(value="impressionLabel", required=false) String var5, @RequestParam(value="limit", defaultValue="20") int var6, @RequestParam(value="page", defaultValue="1") int var7);

    @GetMapping(value={"/api/order/evaluate/weappSearchCount"})
    public Response<Integer> weappSearchCountEvaluation(@RequestParam(value="code", required=false) String var1, @RequestParam(value="statisWay", required=false) EvaluateStatisOption.EvaluateStatisWay var2, @RequestParam(value="visible", required=false) Boolean var3, @RequestParam(value="perfect", required=false) Boolean var4, @RequestParam(value="impressionLabel", required=false) String var5);

    @PostMapping(value={"/api/order/evaluate/statis/summarize"})
    public Response<Map<String, OrderEvaluateSummaryStatistic>> summarizeEvaluation(@RequestBody List<EvaluateStatisOption> var1);

    @PostMapping(value={"/api/order/oil/createOrder"})
    public Response<SaleOrder> createOilTicketOrder(@RequestBody OilOrderCreateDto var1);

    @PostMapping(value={"/api/order/oil/payOrder"})
    public Response<OilOrderPayedResultDto> payOilTicketOrder(@RequestBody OilOrderPayDto var1);

    @GetMapping(value={"/api/order/oil/manualCreateOilTrade/{orderCode}"})
    public Response<String> manualIssueCreateOilTrade(@PathVariable(value="orderCode") String var1);

    @PostMapping(value={"/api/order/oil/deposit/updateDepositOrder"})
    public Response<String> updateDepositWhenOilCreatedOrder(@RequestParam(value="orderCode") String var1, @RequestParam(value="tradeNo") String var2);

    @GetMapping(value={"/api/order/oil/deposit/findPendingRetryDeposit"})
    public Response<List<OrderOilDeposit>> findPendingRetryDeposit();

    @GetMapping(value={"/api/order/oil/deposit/getDepositOrderDetail/{tradeNo}"})
    public Response<OrderOilDeposit> getDepositOrderDetailByTradeNo(@PathVariable(value="tradeNo") String var1, @RequestParam(value="isLoadRecords", required=false) boolean var2);

    @PostMapping(value={"/api/order/oil/deposit/updateRetryTimes"})
    public Response<String> updateRetryTimesAndReason(@RequestBody OrderOilDeposit var1);

    @PostMapping(value={"/api/order/oil/depositRecord/save"})
    public Response<OilDepositRecord> saveDepositRecord(@RequestBody OilDepositRecord var1);

    @GetMapping(value={"/api/order/oil/depositRecord/weappSearch"})
    public PageTable<OilDepositRecord> weappSearchDepositRecord(@RequestParam(value="userCode", required=true) String var1, @RequestParam(value="orderCode", required=false) String var2, @RequestParam(value="depositMobile", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @GetMapping(value={"/api/order/oil/depositRecord/summarize"})
    public Response<DepositSummaryStatistic> summarizeDeposit(@RequestParam(value="userCode", required=true) String var1, @RequestParam(value="orderCode", required=false) String var2, @RequestParam(value="depositMobile", required=false) String var3);

    @GetMapping(value={"/api/order/trace/error"})
    public PageTable<OrderErrorTrace> searchErrorTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="bussType", required=false) BussiTypeEnum var2, @RequestParam(value="callApi", required=false) CallApiEnum var3, @RequestParam(value="system", required=false) BussiSystemEnum var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/error/save"})
    public Response<String> saveErrorTrace(@RequestBody OrderErrorTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi"})
    public PageTable<OrderThirdTrace> searchThirdCallTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="callApiPath", required=false) String var2, @RequestParam(value="sourcePlatform", required=false) String var3, @RequestParam(value="targetPlatform", required=false) String var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/thirdApi/save"})
    public Response<String> saveThirdCallTrace(@RequestBody OrderThirdTrace var1);
}

