/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class ArithUtil {
    private static final int DEF_DIV_SCALE = 10;

    public static double add(double v1, double v2) {
        return v1 + v2;
    }

    public static double sub(double v1, double v2) {
        return v1 - v2;
    }

    public static double mutiply(double v1, double v2) {
        return v1 * v2;
    }

    public static double div(double v1, double v2) {
        return ArithUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal d1 = new BigDecimal(Double.toString(v1));
        BigDecimal d2 = new BigDecimal(Double.toString(v2));
        return d1.divide(d2, scale, 4).doubleValue();
    }

    public static String divideToPercent(BigDecimal a, BigDecimal b) {
        BigDecimal result = ArithUtil.bigDecimalDivide(a, b, 4).multiply(new BigDecimal("100"));
        return ArithUtil.formatMoney(result) + "%";
    }

    public static double round(double v, int scale) {
        return ArithUtil.roundToBigDecimal(v, scale).doubleValue();
    }

    public static BigDecimal roundToBigDecimal(double value, int scale) {
        return ArithUtil.roundToBigDecimal(new BigDecimal(String.valueOf(value)), scale);
    }

    public static BigDecimal roundToBigDecimal(BigDecimal value, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        return value.divide(BigDecimal.ONE, scale, 4);
    }

    public static BigDecimal roundToTwoScaleBigDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(2, 4);
    }

    public static BigDecimal halfValue(BigDecimal num) {
        if (num == null) {
            return null;
        }
        return num.divide(new BigDecimal(2), 2, 4);
    }

    public static int roundDown(double v) {
        BigDecimal b = new BigDecimal(Double.toString(v));
        return b.divide(BigDecimal.ONE, 0, 1).intValue();
    }

    public static int roundUp(double v) {
        BigDecimal b = new BigDecimal(Double.toString(v));
        return b.divide(BigDecimal.ONE, 0, 0).intValue();
    }

    public static int roundHalfUp(double v) {
        return new BigDecimal(v).setScale(0, 4).intValue();
    }

    public static String getCurrency(double money) {
        NumberFormat formatter = NumberFormat.getCurrencyInstance(Locale.CHINA);
        return formatter.format(money);
    }

    public static double format(BigDecimal num, int len) {
        if (num == null) {
            return 0.0;
        }
        len = len < 0 ? 2 : len;
        String pattern = "#." + StringUtils.rightPad((String)"", (int)len, (char)'0');
        DecimalFormat df = new DecimalFormat(pattern);
        return Double.valueOf(df.format(num));
    }

    public static String formatMoney(double amount) {
        String money;
        int intPart = (int)amount;
        if (amount != (double)intPart) {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setMaximumFractionDigits(2);
            money = fmt.format(amount);
            money = money.replace(",", "");
        } else {
            money = String.valueOf(intPart);
        }
        return money;
    }

    public static String formatMoney(BigDecimal amount) {
        if (amount == null) {
            return "0";
        }
        return ArithUtil.formatMoney(amount.doubleValue());
    }

    public static double percentToDouble(String percent) {
        String floatNum = percent.substring(0, percent.length() - 1);
        double n = NumberUtils.toDouble((String)floatNum);
        return n /= 100.0;
    }

    public static BigDecimal bigDecimalMultiply(BigDecimal v1, BigDecimal ... v2) {
        if (v1 == null || v2 == null) {
            return new BigDecimal(0);
        }
        if (v2.length == 0) {
            return v1;
        }
        BigDecimal product = v1;
        for (BigDecimal v : v2) {
            product = product.multiply(v);
        }
        return product;
    }

    public static BigDecimal bigDecimalDivide(BigDecimal v1, BigDecimal v2, int scale) {
        if (v1 == null || v2.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return v1.divide(v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal bigDecimalAdd(BigDecimal ... vs) {
        if (vs == null || vs.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal v : vs) {
            if (v == null) continue;
            sum = sum.add(v);
        }
        return sum;
    }

    public static BigDecimal bigDecimalSubtract(BigDecimal v, BigDecimal ... vs) {
        if (v == null) {
            throw new RuntimeException("\u51cf\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (vs == null || vs.length == 0) {
            return v;
        }
        for (BigDecimal val : vs) {
            if (val == null) continue;
            v = v.subtract(val);
        }
        return v;
    }

    public static boolean betweenSection(BigDecimal value, BigDecimal lower, BigDecimal upper) {
        return value.compareTo(lower) >= 0 && value.compareTo(upper) <= 0;
    }

    public static BigDecimal pow(double v1, double v2) throws Exception {
        if (v1 == 0.0 || v2 == 0.0) {
            throw new Exception("\u5e95\u6570\u6216\u6b21\u65b9\u6570\u4e0d\u80fd\u4e3a\u96f6!");
        }
        return new BigDecimal(Math.pow(v1, v2));
    }
}

