package com.rocogz.syy.order.dto;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 订单服务项目信息Dto
 * @author zhangmin
 * @date 2020/4/28
 */
@Setter @Getter
public class OrderServiceItemDto {

    /**
     * 专区服务项目编号
     */
    private String areaServiceCode;

    /**
     * 专区编号
     */
    private String areaCode;

    /**
     * 专区名称
     */
    private String areaName;

    /**
     * 商户服务项目编号
     */
    private String storeServiceCode;

    /**
     * 商户服务项目名称
     */
    private String storeServiceName;

    /**
     * 商户服务项目状态
     */
    private String status;

    /**
     * 服务分类编号
     */
    private String serviceCatalogCode;

    /**
     * 服务所属商户编号
     */
    private String storeCode;

    /**
     * 服务所属门店名
     */
    private String storeName;

    /**
     * 行业编号
     */
    private String industryCode;

    /**
     * 商户结算价
     */
    private BigDecimal storeSettlePrice;

    /**
     * 企业客户结算价，如人保结算价
     */
    private BigDecimal enterpriceSettlePrice;

    /**
     * 结算方主体编号
     */
    private String enterpriceCode;

}
