package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.appoint.OrderAppointment;
import com.rocogz.syy.order.entity.oil.OrderOilDeposit;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单主信息表
 * </p>
 * @author zhangmin
 * @since 2020-04-26
 */
@TableName("order_sale_order")
@Setter @Getter
@Accessors(chain = true)
public class SaleOrder extends BaseUserInfo {

    private static final long serialVersionUID=1L;

    /**
     * 订单类型编号：服务券订单，加油电子券订单，预约订单
     * @see OrderConstant.DictOrderType
     */
    private String orderType;

    /**
     * 下单来源平台编号，如：SYY
     * 该平台码来源于 基础服务系统中：basic_docking_platform表
     */
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用
     * @see OrderConstant.DictChannel
     */
    private String channel;

    /**
     * 订单状态：处理中,待支付，待使用，待评价，已评价，已取消，已过期
     * @see OrderConstant.DictOrderStatus
     */
    private String status;


    /**
     * 取消订单时间
     */
    private LocalDateTime cancelTime;

    /**
     * 过期时间,该时间来源于用户券
     */
    private LocalDateTime expireTime;

    /**
     * 使用时间，目前与核销时间相同
     */
    private LocalDateTime usedTime;

    /**
     * 是否已被人评价过
     */
    private Boolean evaluated;

    /**
     * 是否被逻辑删除,即是否被会员自己删除了
     */
    private Boolean deleted;

    //服务项目信息
    @TableField(exist = false)
    private OrderServiceItem serviceItem;

    //支付单
    @TableField(exist = false)
    private OrderPayment payment;

    //核销信息
    @TableField(exist = false)
    private OrderWriteOff writeOff;

    //结算信息
    @TableField(exist = false)
    private OrderSettlement settlement;


    //电子加油券充值单 [加油电子券订单 专有]
    @TableField(exist = false)
    private OrderOilDeposit deposit;

    //预约信息[预约订单 专有]
    @TableField(exist = false)
    private OrderAppointment appoint;

    /**
     * =====> 以下都是为了页面展示数据用的
     */
    private transient String orderTypeLabel;
    private transient String statusLabel;
    private transient String channelLabel;
    //平台名称
    private transient String platformName;


    /**
     * 该订单是否已核销
     * @return
     */
    @JsonIgnore
    public boolean isWritedOff() {
        return OrderConstant.DictOrderStatus.PENDING_EVALUATE.equals(status) || OrderConstant.DictOrderStatus.EVALUATED.equals(status);
    }
}
