package com.rocogz.syy.order.dto;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;

/**
 * 描述：前端js传入 核销请求参数
 * @author zhangmin
 */
@Setter
@Getter
public class WriteOffUIParamDto {

    /**
     * 前端传入的核销码(扫码的核销码/用户输入的核销码) [必传]
     */
    private String writeOffCodeParam;

    /**
     * 商户服务项目 [必传]
     */
    private String storeServiceCode;

    /**
     * 下单车牌号 [必传]
     */
    private String license;

    /**
     * 下单车辆类型 [必传]
     * 车辆类型：CAR("小型车"),SUV ,MPV, OTHER("其他车型"),ALL("不区分车型")
     * basic_dict_data 表中 AREA_SERVICE_CAR_TYPE类型的字典数据
     */
    private String carType;

    /**
     * 核销方式 [必传]
     *
     * @see OrderConstant.DictWriteOffWay
     */
    private String writeOffWay;


    /**
     * 服务券系统使用的核销码, 调用方 要前端传入券的先处理成券系统格式的核销码
     * 前端传入格式：SF42A-1AB6-2BC8-1727
     * 券系统格式： F42A1AB62BC81727
     *
     * 预约订单核销码格式：
     */
    private String writeOffCode;

}
