package com.rocogz.syy.order.dto.evaluate;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 被评价的 订单信息dto,后台评价搜索 时使用
 * @author zhangmin
 * @date 2020/5/23
 */
@Setter @Getter
public class EvaluatedOrderDto {

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 会员手机号
     */
    private String mobile;

    /**
     * 下单时间
     */
    private LocalDateTime createTime;


    //掩码手机号 => 131234****1
    public String getMaskMobile() {
        if(StringUtils.isBlank(mobile)) {
            return mobile;
        }

        String maskMobile = mobile.replaceAll("(\\d{6})\\d{4}(\\d{1})","$1****$2");
        return maskMobile;
    }


}
