package com.rocogz.syy.order.dto.oil;

import com.rocogz.syy.order.constant.OilTicketOrderConstant;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 管理后台-> 加油电子券订单 搜索 条件
 * @author zhangmin
 * @date 2020/5/12
 */
@Data
public class OilAdminSearchParamDto extends AdminBaseSearchDto  {

    public OilAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.OIL_TICKET_ORDER);
    }


    /**
     * 加油订单类型
     * @see OilTicketOrderConstant.DictOilTicketType
     */
    private String oilType;

    /**
     * 油卡系统交易号/主订单号 [油卡系统订单创建成功后更新此字段]
     */
    private String tradeNo;

    /**
     * 充值手机号
     */
    private String depositMobile;


    /**
     * 充值金额
     */
    private BigDecimal depositAmt;

    /**
     * 到账金额
     */
    private BigDecimal successAmt;

    /**
     * 充值状态：如：待充值、充值中,充值完成 [刚创建时状态为null,油卡系统创建订单成功后更新为待充值]
     * @see OilTicketOrderConstant.DictDepositStatus
     */
    private String depositStatus;


    /**
     * 油卡系统下单时间-起始
     */
    private String tradeStartTime;

    /**
     * 油卡系统下单时间
     */
    private String tradeEndTime;
}
