package com.rocogz.syy.order.constant;

import java.math.BigDecimal;

/**
 * 常量
 *
 * @author：zhangmin
 * @since：2020/4/6
 */
public final class OrderConstant {

    public static final String APPLICATION_NAME = "order-base-service";

    /**
     * 对接平台 roco车服平台码,该平台码 来源于 基础服务系统中：basic_docking_platform表
     */
    public static final String DICT_PLATFORM_CODE_CAR_SERVICE = "SYY";

    /**
     * 元和分的转换进制, 微信支付时使用的是分为单位.
     */
    public static final BigDecimal YUAN_FEE_EXCHANGE = new BigDecimal(100);

    /**
     * 订单类型
     */
    public static class DictOrderType {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_TYPE";

        //=== 下面是字典值

        /**
         *服务券订单 (走的是商户端核销下单流程)
         *订单状态变化流程如下：
         * 商户端通过核销码核销 -> 核销下单成功（PROCESSING）->核销完成(PENDING_EVALUATE)-> 发布评价(EVALUATED)
         */
        public static final String COUPON_ORDER = "COUPON_ORDER";

        /**
         * 电子加油券订单(走的是加油卡券直接下单流程)
         * 订单状态变化流程如下：
         * 车主端下单（PENDING_PAY）-> 车主端调用支付成功后(PROCESSING) -> 充值完成后（PENDING_EVALUATE）
         */
        public static final String OIL_TICKET_ORDER = "OIL_TICKET_ORDER";

        /**
         * 预约订单
         * 订单状态变化流程如下：
         * 人保车务平台通过interface聚合项目下单(PENDING_USE) -> 核销完成（PENDING_EVALUATE）
         */
        public static final String APPOINTMENT_ORDER = "APPOINTMENT_ORDER";

    }


    /**
     * 下订单渠道
     */
    public static class DictChannel {
        //字典类型编号
        public static final String TYPE_CODE = "CHANNEL";

        //=== 下面是字典值

        //车主端
        public static final String CAR_OWNER_WEAPP = "CAR_OWNER_WEAPP";

        //商户端
        public static final String MERCHANT_WEAPP = "MERCHANT_WEAPP";

        //管理后台
        public static final String ADMIN_DASHBOARD = "ADMIN_DASHBOARD";

        //接口调用
        public static final String API_CALL = "API_CALL";
    }

    /**
     * 下单状态
     */
    public static class DictOrderStatus {
        //字典类型编号
        public static final String TYPE_CODE = "SALE_ORDER_STATUS";

        //=== 下面是字典值

        //待支付 （加油电子券订单刚创建时状态是待支付, 支付成功后是  "处理中"）
        public static final String PENDING_PAY = "PENDING_PAY";

        //处理中
        public static final String PROCESSING = "PROCESSING";

        //待使用,支付成功后就是待使用
        public static final String PENDING_USE = "PENDING_USE";

        //待评价,使用以后（核销成功后）就是待评价
        public static final String PENDING_EVALUATE = "PENDING_EVALUATE";

        //已评价
        public static final String EVALUATED = "EVALUATED";

        //已取消
        public static final String CANCELED = "CANCELED";

        //已过期
        public static final String EXPIRED = "EXPIRED";
    }


    /**
     * 订单支付方式
     */
    public static class DictPayWay {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_WAY";

        //=== 下面是字典值

        //电子券支付
        public static final String TICKET = "TICKET";

        //加油电子券支付
        public static final String OIL_TICKET = "OIL_TICKET";

        //代金券支付
        public static final String VOUCHER = "VOUCHER";

        //服务券支付
        public static final String COUPON = "COUPON";

        //外系统预约支付
        public static final String EXTERNAL_APPOINT = "EXTERNAL_APPOINT";
        //现金支付之 微信支付
        public static final String WEIXIN = "WEIXIN";
        //现金支付之 支付宝支付
        public static final String ALIPAY = "ALIPAY";

    }

    /**
     * 支付单的 支付状态
     */
    public static class DictPayStatus {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_STATUS";

        //=== 下面是字典值

        //未支付
        public static final String UN_PAY = "UNPAY";

        //部分支付
        public static final String PART_PAY = "PART_PAY";

        //支付完成
        public static final String PAIED = "PAIED";

    }


    /**
     * 订单退款状态
     */
    public static class DictRefundStatus {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_REFUND_STATUS";

        //=== 下面是字典值
        //退款中
        public static final String REFUNDING = "REFUNDING";

        //已退回
        public static final String REFUNDED = "REFUNDED";
    }

    /**
     * 订单核销方式
     */
    public static class DictWriteOffWay {

        //字典类型编号
        public static final String TYPE_CODE = "WRITE_OFF_WAY";

        //=== 下面是字典值

        // 商户端扫码
        public static final String SCAN_QR_CODE = "SCAN_QR_CODE";

        //商户端输入核销码
        public static final String INPUT_CODE = "INPUT_CODE";

        //后台手工核销
        public static final String ADMIN_MANUAL = "ADMIN_MANUAL";

    }

    /**
     * 订单 操作动作,用来记录操作流水
     */
    public static final class DictOrderAction {

        //字典类型编号
        public static final String TYPE_CODE = "ORDER_ACTION";

        //=== 下面是字典值

        //创建订单
        public static final String CREATE = "CREATE";

        //支付订单
        public static final String PAY = "PAY";

        //订单使用券
        public static final String USE_COUPON = "USE_COUPON";

        //核销订单
        public static final String WRITE_OFF = "WRITE_OFF";

        //取消订单
        public static final String CANCEL = "CANCEL";

        //结算
        public static final String SETTLE = "SETTLE";

        //逻辑删除
        public static final String DELETE = "DELETE";

        //充值完成【加油电子券订单】
        public static final String FINISH_DEPOSIT = "FINISH_DEPOSIT";



        // ===下面是 订单的评价 相关操作

        //发布评价
        public static final String PUBLISH_EVALUATION = "PUBLISH_EVALUATION";

        //设置精选
        public static final String SET_PERFECT = "SET_PERFECT";

        //取消精选
        public static final String CANCEL_PERFECT = "CANCEL_PERFECT";

        //隐藏评价
        public static final String HIDE_EVALUATION = "HIDE_EVALUATION";

        //显示评价
        public static final String SHOW_EVALUATION = "SHOW_EVALUATION";

        //删除评价
        public static final String DELETE_EVALUATION = "DELETE_EVALUATION";
    }





    /**
     * 订单 结算状态
     */
    public static class DictSettleStatus {

        //字典类型编号
        public static final String TYPE_CODE = "SETTLEMENT_STATUS";

        //=== 下面是字典值

        // 未结算
        public static final String UN_SETTLE = "UN_SETTLE";

        //已结算
        public static final String SETTLED = "SETTLED";

    }

    /**
     * 车辆类型字典数据 在商户中心项目中已经有了，所以直接共用1份数据
     */
    public static class DictCarType {
        //字典类型编号
        public static final String TYPE_CODE = "AREA_SERVICE_CAR_TYPE";
    }


    /**
     * 订单评价 来源
     */
    public static class DictEvaluationOrigin {
        //字典类型编号
        public static final String TYPE_CODE = "EVALUATE_ORIGIN";

        //=== 下面是字典值
        // 自动评价
        public static final String AUTO = "AUTO";

        //会员评价
        public static final String USER = "USER";

    }

}
