package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-商品订单转赠信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order_bestow_info")
public class GoodsOrderBestowInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 转赠记录编号
     */
    private String bestowCode;

    /**
     * 转赠来源/渠道
     */
    private String bestowChannel;

    /**
     * 转赠人的用户编码
     */
    private String senderUserCode;

    /**
     * 赠送时间
     */
    private LocalDateTime sendTime;

    /**
     * 接受者手机号
     */
    private String receiverMobile;

    /**
     * 接受者手机号
     */
    private String receiverUserCode;

    /**
     * 接受者领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 备注
     */
    private String remark;


}
