/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.order.constant.EvaluateStatisOption;
import com.rocogz.syy.order.constant.OrderStatisOption;
import com.rocogz.syy.order.constant.OtherInfoOption;
import com.rocogz.syy.order.constant.StatisTimeRangeEnum;
import com.rocogz.syy.order.constant.trace.BussiSystemEnum;
import com.rocogz.syy.order.constant.trace.BussiTypeEnum;
import com.rocogz.syy.order.constant.trace.CallApiEnum;
import com.rocogz.syy.order.dto.AdminSearchParamDto;
import com.rocogz.syy.order.dto.CancelOrderResultDto;
import com.rocogz.syy.order.dto.OrderCashPayDto;
import com.rocogz.syy.order.dto.OrderCentPayDto;
import com.rocogz.syy.order.dto.OrderCreateCentExchangeDto;
import com.rocogz.syy.order.dto.OrderSummaryStatistic;
import com.rocogz.syy.order.dto.OrderWriteOffDto;
import com.rocogz.syy.order.dto.appoint.AppointAdminSearchParamDto;
import com.rocogz.syy.order.dto.appoint.AppointWriteOffDto;
import com.rocogz.syy.order.dto.appoint.AppointWriteOffPreparedDataDto;
import com.rocogz.syy.order.dto.appoint.CreateAppointOrderDto;
import com.rocogz.syy.order.dto.evaluate.AdminSearchEvaluationParamDto;
import com.rocogz.syy.order.dto.evaluate.OrderEvaluateSummaryStatistic;
import com.rocogz.syy.order.dto.goods.CreateGoodsOrderDto;
import com.rocogz.syy.order.dto.goods.GoodsAdminSearchParamDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderChangeStatusDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderReceiveDto;
import com.rocogz.syy.order.dto.oil.DepositSummaryStatistic;
import com.rocogz.syy.order.dto.oil.OilAdminSearchParamDto;
import com.rocogz.syy.order.dto.oil.OilOrderCreateDto;
import com.rocogz.syy.order.dto.oil.OilOrderPayDto;
import com.rocogz.syy.order.dto.oil.OilOrderPayedResultDto;
import com.rocogz.syy.order.dto.oil.OilOrderWithCashCreateDto;
import com.rocogz.syy.order.dto.oil.OilTicketExchangeDetailDto;
import com.rocogz.syy.order.dto.pay.WxPayRefundParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderResultDto;
import com.rocogz.syy.order.dto.peccancy.CreatePeccancyOrderDto;
import com.rocogz.syy.order.dto.peccancy.PeccancyAdminSearchParamDto;
import com.rocogz.syy.order.dto.peccancy.PeccancyRecordTotalDto;
import com.rocogz.syy.order.dto.peccancy.QueryPeccancyConditionsDto;
import com.rocogz.syy.order.dto.trace.ApiRequestLogStatisticsResponseDto;
import com.rocogz.syy.order.dto.withdrawals.CreateWithdrawalsOrderDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsAdminSearchParamDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsOrderChangeStatusDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsSummaryResultDto;
import com.rocogz.syy.order.entity.evaluate.OrderEvaluate;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import com.rocogz.syy.order.entity.oil.OilDepositRecord;
import com.rocogz.syy.order.entity.oil.OrderOilDeposit;
import com.rocogz.syy.order.entity.orders.OrderLog;
import com.rocogz.syy.order.entity.orders.OrderPayment;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.entity.pay.WxPayRecord;
import com.rocogz.syy.order.entity.pay.WxPayRefundRecord;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrder;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyQueryRecord;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyRecord;
import com.rocogz.syy.order.entity.trace.OrderErrorTrace;
import com.rocogz.syy.order.entity.trace.OrderThirdTrace;
import com.rocogz.syy.order.entity.withdrawals.WithdrawalsRecord;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOrderClientService {
    @PostMapping(value={"/api/order/create"})
    public Response createOrder(@RequestBody SaleOrder var1);

    @GetMapping(value={"/api/order/adminSearch"})
    public PageTable<SaleOrder> adminSearch(@SpringQueryMap AdminSearchParamDto var1);

    @GetMapping(value={"/api/order/getOrderMainInfo/{orderCode}"})
    public Response<SaleOrder> getOrderMainInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderWithOtherInfo/{orderCode}"})
    public Response<SaleOrder> getOrderWithOtherInfo(@PathVariable(value="orderCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/getOrderWithOtherByIdentifyCode/{identifyCode}"})
    public Response<SaleOrder> getOrderWithOtherByIdentifyCode(@PathVariable(value="identifyCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/weappSearch"})
    public PageTable<SaleOrder> weappSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="orderTypeList", required=false) List<String> var3, @RequestParam(value="limit", defaultValue="10") Integer var4, @RequestParam(value="page", defaultValue="1") Integer var5);

    @GetMapping(value={"/api/order/merchantWeappSearch"})
    public PageTable<SaleOrder> merchantWeappSearch(@RequestParam(value="storeCode") String var1, @RequestParam(value="keyword", required=false) String var2, @RequestParam(value="orderTypeList", required=false) List<String> var3, @RequestParam(value="statusList", required=false) List<String> var4, @RequestParam(value="appointStartTime", required=false) String var5, @RequestParam(value="appointEndTime", required=false) String var6, @RequestParam(value="limit", defaultValue="10") Integer var7, @RequestParam(value="page", defaultValue="1") Integer var8);

    @GetMapping(value={"/api/order/delete/{orderCode}"})
    public Response<String> deleteLogical(@PathVariable(value="orderCode") String var1, @RequestParam(value="userCode", required=false) String var2);

    @GetMapping(value={"/api/order/cancelOrder/{orderCode}"})
    public Response<CancelOrderResultDto> cancelOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/log/{orderCode}"})
    public Response<List<OrderLog>> findLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/scheduleExpireOrder"})
    public Response<String> scheduleExpireOrder();

    @GetMapping(value={"/api/order/scheduleFindCashPayTimeoutOrderCodes"})
    public Response<List<String>> scheduleFindCashPayTimeOutOrderCodes();

    @GetMapping(value={"/api/order/statis/countGroupByStatus"})
    public Response<Map<String, Long>> countOrderNumGroupByStatus(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(value="userCode", required=false) String var2);

    @PostMapping(value={"/api/order/statis/summarize"})
    public Response<Map<StatisTimeRangeEnum, OrderSummaryStatistic>> summarizeOrderByStoreCode(@RequestBody List<OrderStatisOption> var1);

    @GetMapping(value={"/api/order/statis/countNewest/{storeCode}"})
    public Response<Map<String, Long>> countNewestOrderByStoreCode(@PathVariable(value="storeCode") String var1);

    @PostMapping(value={"/api/order/writeOff/validateBeforeWriteOff"})
    public Response<String> validateBeforeWriteOff(@RequestBody OrderWriteOffDto var1);

    @PostMapping(value={"/api/order/writeOff/createOrder"})
    public Response<SaleOrder> createOrderWhenWriteOff(@RequestBody OrderWriteOffDto var1);

    @PostMapping(value={"/api/order/writeOff/updateOrderStatus"})
    public Response<String> updateStatusWithSaveLog(@RequestBody List<OrderLog> var1);

    @PostMapping(value={"/api/order/centExchange/createCentExchangeOrder"})
    public Response<SaleOrder> createCentExchangeOrder(@RequestBody OrderCreateCentExchangeDto var1);

    @PostMapping(value={"/api/order/centExchange/payCentExchangeOrder"})
    public Response payCentExchangeOrder(@RequestBody OrderCentPayDto var1);

    @PostMapping(value={"/api/order/evaluate/create"})
    public Response<OrderEvaluate> createEvaluate(@RequestBody OrderEvaluate var1);

    @GetMapping(value={"/api/order/evaluate/{orderCode}"})
    public Response<OrderEvaluate> getEvaluateByOrderCode(@PathVariable(value="orderCode") String var1, @RequestParam(value="loadOtherFlag", required=false) Integer var2);

    @GetMapping(value={"/api/order/evaluate/delete/{orderCode}"})
    public Response<String> deleteEvaluate(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/togglePerfect/{orderCode}"})
    public Response<String> toggleEvaluatePerfect(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/toggleVisibility/{orderCode}"})
    public Response<String> toggleEvaluateVisibility(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/adminSearch"})
    public PageTable<OrderEvaluate> adminSearchEvaluation(@SpringQueryMap AdminSearchEvaluationParamDto var1);

    @GetMapping(value={"/api/order/evaluate/weappSearch"})
    public PageTable<OrderEvaluate> weappSearchEvaluation(@RequestParam(value="code", required=false) String var1, @RequestParam(value="statisWay", required=false) EvaluateStatisOption.EvaluateStatisWay var2, @RequestParam(value="visible", required=false) Boolean var3, @RequestParam(value="perfect", required=false) Boolean var4, @RequestParam(value="impressionLabel", required=false) String var5, @RequestParam(value="limit", defaultValue="20") int var6, @RequestParam(value="page", defaultValue="1") int var7);

    @GetMapping(value={"/api/order/evaluate/weappSearchCount"})
    public Response<Integer> weappSearchCountEvaluation(@RequestParam(value="code", required=false) String var1, @RequestParam(value="statisWay", required=false) EvaluateStatisOption.EvaluateStatisWay var2, @RequestParam(value="visible", required=false) Boolean var3, @RequestParam(value="perfect", required=false) Boolean var4, @RequestParam(value="impressionLabel", required=false) String var5);

    @PostMapping(value={"/api/order/evaluate/statis/summarize"})
    public Response<Map<String, OrderEvaluateSummaryStatistic>> summarizeEvaluation(@RequestBody List<EvaluateStatisOption> var1);

    @PostMapping(value={"/api/order/oil/createOrder"})
    public Response<SaleOrder> createOilTicketOrder(@RequestBody OilOrderCreateDto var1);

    @PostMapping(value={"/api/order/oil/createWithCashOrder"})
    public Response<SaleOrder> createWithCashOilTicketOrder(@RequestBody OilOrderWithCashCreateDto var1);

    @PostMapping(value={"/api/order/oil/payOrder"})
    public Response<OilOrderPayedResultDto> payOilTicketOrder(@RequestBody OilOrderPayDto var1);

    @PostMapping(value={"/api/order/oil/cashPayOrder"})
    public Response payOilTickOrderByCash(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/order/oil/manualCreateOilTrade/{orderCode}"})
    public Response<String> manualIssueCreateOilTrade(@PathVariable(value="orderCode") String var1);

    @PostMapping(value={"/api/order/oil/deposit/updateDepositOrder"})
    public Response<String> updateDepositWhenOilCreatedOrder(@RequestParam(value="orderCode") String var1, @RequestParam(value="tradeNo") String var2);

    @GetMapping(value={"/api/order/oil/deposit/findPendingRetryDeposit"})
    public Response<List<OrderOilDeposit>> findPendingRetryDeposit();

    @GetMapping(value={"/api/order/oil/deposit/getDepositOrderDetail/{tradeNo}"})
    public Response<OrderOilDeposit> getDepositOrderDetailByTradeNo(@PathVariable(value="tradeNo") String var1, @RequestParam(value="isLoadRecords", required=false) boolean var2);

    @PostMapping(value={"/api/order/oil/deposit/updateRetryTimes"})
    public Response<String> updateRetryTimesAndReason(@RequestBody OrderOilDeposit var1);

    @GetMapping(value={"/api/order/oil/deposit/exchangeDetail/{userCouponCode}"})
    public Response<OilTicketExchangeDetailDto> getExchangeDetail(@PathVariable(value="userCouponCode") String var1);

    @PostMapping(value={"/api/order/oil/depositRecord/save"})
    public Response<OilDepositRecord> saveDepositRecord(@RequestBody OilDepositRecord var1);

    @GetMapping(value={"/api/order/oil/depositRecord/manualResendExchangeMsg/{orderCode}"})
    public Response<String> manualResendExchangeMsg(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/depositRecord/weappSearch"})
    public PageTable<OilDepositRecord> weappSearchDepositRecord(@RequestParam(value="userCode", required=true) String var1, @RequestParam(value="orderCode", required=false) String var2, @RequestParam(value="depositMobile", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @GetMapping(value={"/api/order/oil/depositRecord/summarize"})
    public Response<DepositSummaryStatistic> summarizeDeposit(@RequestParam(value="userCode", required=true) String var1, @RequestParam(value="orderCode", required=false) String var2, @RequestParam(value="depositMobile", required=false) String var3);

    @GetMapping(value={"/api/order/oil/adminSearch"})
    public PageTable<SaleOrder> adminOilOrderSearch(@SpringQueryMap OilAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/oil/getOrderOilPaymentInfo/{orderCode}"})
    public Response<OrderPayment> getOrderOilPaymentInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOrderOilPaymentLogList/{orderCode}"})
    public Response<OrderPayment> getOrderOilPaymentLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOilDepositRecordList/{orderCode}"})
    public Response<List<OilDepositRecord>> getOilDepositRecordList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/appoint/countAppintNum"})
    public Response<Map<String, Integer>> countAppintNum(@RequestParam(value="storeServiceCode") String var1, @RequestParam(value="timeRangeList") List<String> var2);

    @GetMapping(value={"/api/order/appoint/getAppointedNum"})
    public Response<Integer> getAppointedNum(@RequestParam(value="storeServiceCode") String var1, @RequestParam(value="startTime") String var2, @RequestParam(value="endTime") String var3);

    @GetMapping(value={"/api/order/appoint/updateAppointUserInfo"})
    public Response<String> updateUserInfoByAppoitMobileWhenBound(@RequestParam(value="userCode") String var1, @RequestParam(value="openId") String var2, @RequestParam(value="userMobile") String var3);

    @PostMapping(value={"/api/order/appoint/createAppoint"})
    public Response<String> createAppointOrder(@RequestBody CreateAppointOrderDto var1);

    @GetMapping(value={"/api/order/appoint/prepareDataBeforeWriteOff/{thirdWriteOffCode}"})
    public Response<AppointWriteOffPreparedDataDto> prepareDataBeforeWriteOffAppointment(@PathVariable(value="thirdWriteOffCode") String var1);

    @PostMapping(value={"/api/order/appoint/doWriteOff"})
    public Response<SaleOrder> writeOffAppointOrder(@RequestBody AppointWriteOffDto var1);

    @GetMapping(value={"/api/order/appoint/internelCancelOrder/{orderCode}"})
    public Response<String> internelCancelAppointOrder(@PathVariable(value="orderCode") String var1, @RequestParam(value="actionUser", required=false) String var2, @RequestParam(value="channel") String var3);

    @GetMapping(value={"/api/order/appoint/externelCancelOrder/{thirdOrderCode}"})
    public Response<String> externelCancelAppointOrder(@PathVariable(value="thirdOrderCode") String var1, @RequestParam(value="thirdWriteOffCode") String var2);

    @GetMapping(value={"/api/order/appoint/adminSearch"})
    public PageTable<SaleOrder> adminSearchAppointOrder(@SpringQueryMap AppointAdminSearchParamDto var1);

    @PostMapping(value={"/api/order/peccancy/createPeccancyOrder"})
    public Response<SaleOrder> createPeccancyOrder(@RequestBody CreatePeccancyOrderDto var1);

    @PostMapping(value={"/api/order/peccancy/cashPayOrder"})
    public Response payPeccancyOrderByCash(@RequestBody OrderCashPayDto var1);

    @PostMapping(value={"/api/order/peccancy/update"})
    public Response<String> updatePeccancyByOrderCode(@RequestBody OrderPeccancyOrder var1);

    @GetMapping(value={"/api/order/peccancy/findPendingRetry"})
    public Response<List<OrderPeccancyOrder>> findPendingRetryPeccancyOrderList();

    @GetMapping(value={"/api/order/peccancy/adminSearch"})
    public PageTable<SaleOrder> adminSearchPeccancyOrder(@SpringQueryMap PeccancyAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/peccancy/manualCreateDingJuOrder/{orderCode}"})
    public Response<String> manualIssueCreateDingJuOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/trace/error"})
    public PageTable<OrderErrorTrace> searchErrorTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="bussType", required=false) BussiTypeEnum var2, @RequestParam(value="callApi", required=false) CallApiEnum var3, @RequestParam(value="system", required=false) BussiSystemEnum var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/error/save"})
    public Response<String> saveErrorTrace(@RequestBody OrderErrorTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi"})
    public PageTable<OrderThirdTrace> searchThirdCallTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="callApiPath", required=false) String var2, @RequestParam(value="sourcePlatform", required=false) String var3, @RequestParam(value="targetPlatform", required=false) String var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/thirdApi/save"})
    public Response<String> saveThirdCallTrace(@RequestBody OrderThirdTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi/pageQueryDistinctApiRequestInterface"})
    public PageTable<OrderThirdTrace> pageQueryDistinctApiRequestInterface(@RequestParam(value="callApiPath", required=false) String var1, @RequestParam(value="startTime") LocalDateTime var2, @RequestParam(value="endTime") LocalDateTime var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @GetMapping(value={"/api/order/trace/thirdApi/getStartTimeAndUsedTimeMillisList"})
    public Response<List<OrderThirdTrace>> getStartTimeAndUsedTimeMillisList(@RequestParam(value="callApiPath", required=false) String var1, @RequestParam(value="startTime") LocalDateTime var2, @RequestParam(value="endTime") LocalDateTime var3);

    @GetMapping(value={"/api/order/trace/thirdApi/statisticsMaxAndAverageUserTime"})
    public Response<ApiRequestLogStatisticsResponseDto> statisticsMaxAndAverageUserTimeApiList(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2);

    @GetMapping(value={"/api/order/wx-pay-record/queryByRocoTradeNoAndStatus"})
    public Response<WxPayRecord> queryWxPayRecordByRocoTradeNoAndStatus(@RequestParam(value="rocoTradeNo") String var1, @RequestParam(value="wxTradeState", required=false) String var2);

    @PostMapping(value={"/api/order/wx-pay-record/updateById"})
    public Response updateWxPayRecordById(@RequestBody WxPayRecord var1);

    @PostMapping(value={"/api/order/pay/wx/unifiedOrder"})
    public Response<WxPayUnifiedOrderResultDto> unifiedWxPayOrder(@RequestBody WxPayUnifiedOrderParamDto var1);

    @GetMapping(value={"/api/order/pay/wx/repayOrder"})
    public Response<WxPayUnifiedOrderResultDto> repayWxPayOrder(@RequestParam(value="outTradeNo") String var1);

    @GetMapping(value={"/api/order/pay/wx/closeOrder/{outTradeNo}"})
    public Response closeWxPayOrder(@PathVariable(value="outTradeNo") String var1);

    @PostMapping(value={"/api/order/pay/wx/refund"})
    public Response<String> refund(@RequestBody WxPayRefundParamDto var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryByRocoRefundNo"})
    public Response<WxPayRefundRecord> queryWxPayRefundRecordByRocoRefundNo(@RequestParam(value="rocoRefundNo") String var1);

    @PostMapping(value={"/api/order/wx-pay-refund-record/updateById"})
    public Response updateWxPayRefundRecordById(@RequestBody WxPayRefundRecord var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyQueryRecord/lastest/query"})
    public Response<OrderPeccancyQueryRecord> lastestQuery(@RequestBody OrderPeccancyQueryRecord var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyQueryRecord/updatelastesttime"})
    public Response peccancyQueryRecordUpdateLastestTime(@RequestBody OrderPeccancyQueryRecord var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/list"})
    public Response peccancyRecord(@RequestBody List<OrderPeccancyRecord> var1);

    @GetMapping(value={"/api/order/peccancy/orderPeccancyQueryRecord/records"})
    public Response<List<OrderPeccancyQueryRecord>> queryPeccancyQueryRecord(@RequestParam(value="userCode") String var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/peccancyRecordByQueryType"})
    public Response<List<OrderPeccancyRecord>> queryPeccancyRecord(@RequestBody OrderPeccancyRecord var1, @RequestParam(value="type", required=false) String var2);

    @GetMapping(value={"/api/order/peccancy/orderPeccancyRecord/queryByPeccancyIdList"})
    public Response<List<OrderPeccancyRecord>> queryPeccancyRecordByIdList(@RequestParam(value="peccancyIdList") List<String> var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/queryBySelfConditions"})
    public Response<List<OrderPeccancyRecord>> queryPeccancyRecordBySelfConditions(@RequestBody QueryPeccancyConditionsDto var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/queryPeccancyRecordTotal"})
    public Response<PeccancyRecordTotalDto> queryPeccancyRecordTotal(@RequestBody OrderPeccancyRecord var1);

    @PostMapping(value={"/api/order/withdrawals-record/createWithdrawalsOrder"})
    public Response<SaleOrder> createWithdrawalsOrder(@RequestBody CreateWithdrawalsOrderDto var1);

    @GetMapping(value={"/api/order/withdrawals-record//getByOrderCode"})
    public Response<WithdrawalsRecord> getWithdrawalsRecordByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/withdrawals-record/savePaymentInfo"})
    public Response saveWithdrawalsPaymentInfo(@Validated @RequestBody OrderCentPayDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/summary"})
    public Response<WithdrawalsSummaryResultDto> getWithdrawalsSummary(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/order/withdrawals-record/sumUsedVirtualCurrencyAmount"})
    public Response<BigDecimal> sumWithdrawalsUsedVirtualCurrencyAmount(@RequestParam(value="userCode") String var1, @RequestParam(value="startTime", required=false) String var2, @RequestParam(value="endTime", required=false) String var3);

    @GetMapping(value={"/api/order/withdrawals-record/approvementCallBack"})
    public Response withdrawalsApprovementCallBack(@RequestParam(value="pass") Boolean var1, @RequestParam(value="code") String var2, @RequestParam(value="updateUser") String var3, @RequestParam(value="remark", required=false) String var4);

    @PostMapping(value={"/api/order/withdrawals-record/changeStatus"})
    public Response changeWithdrawalsOrderStatus(@RequestBody WithdrawalsOrderChangeStatusDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/adminSearch"})
    public PageTable<SaleOrder> adminSearchWithdrawalsOrder(@SpringQueryMap WithdrawalsAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/successRollbackUserCoupon"})
    public Response setWithdrawalsOrderSuccessRollbackUserCoupon(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/withdrawals-record/sendRollbackUserCouponMsg"})
    public Response sendWithdrawalsOrderRollbackUserCouponMsg(@RequestBody WithdrawalsOrderChangeStatusDto var1);

    @GetMapping(value={"/api/order/goods-order/adminSearch"})
    public PageTable<SaleOrder> adminSearchGoodsOrder(@SpringQueryMap GoodsAdminSearchParamDto var1);

    @PostMapping(value={"/api/order/goods-order/create"})
    public Response<SaleOrder> createGoodsOrder(@RequestBody CreateGoodsOrderDto var1);

    @GetMapping(value={"/api/order/goods-order/getByOrderCode"})
    public Response<GoodsOrder> getGoodsOrderByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/goods-order/savePaymentInfo"})
    public Response saveGoodsOrderPaymentInfo(@RequestBody OrderCentPayDto var1);

    @PostMapping(value={"/api/order/goods-order/changeStatus"})
    public Response changeGoodsOrderStatus(@RequestBody GoodsOrderChangeStatusDto var1);

    @PostMapping(value={"/api/order/goods-order/cashPay"})
    public Response<String> payGoodsOrderByCash(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/order/goods-order/listGoodsOrderByOrderCodes"})
    public Response<List<GoodsOrder>> listGoodsOrderByOrderCodes(@RequestParam(value="orderCodeList") List<String> var1);

    @PostMapping(value={"/api/order/goods-order/receive"})
    public Response<GoodsOrder> receiveGoodsOrder(@RequestBody GoodsOrderReceiveDto var1);

    @PostMapping(value={"/api/order/goods-order/receiveGoodsOrderWithAddress"})
    public Response receiveGoodsOrderWithAddress(@RequestBody GoodsOrderDeliveryAddress var1);
}

