package com.rocogz.syy.order.constant;

import lombok.Getter;

/**
 * 查询订单其他信息枚举，查询订单信息时用来实现：按需加载
 * @author zhangmin
 * @date 2020/5/14
 */
@Getter
public enum OtherInfoOption {

    PAYMENT("支付单信息"),
    PAYMENT_WITH_RECORD("支付单及支付明细信息"),


    //服务券订单的其他信息
    SERVICE_ITEM("服务项目信息"),
    WRITE_OFF("核销信息"),
    SETTLEMENT("结算信息"),


    //电子加油券的其他信息
    OIL_DEPOSIT("加油电子券充值单"),
    OIL_DEPOSIT_WITH_RECORD("加油电子券充值单及充值明细"),

    //预约信息
    APPOINTMENT("预约信息"),

    //违章信息
    PECCANCY("违章订单信息"),
    PECCANCY_WITH_ITEM("违章订单以及明细"),

    //提现订单信息
    WITHDRAWALS("提现订单信息"),

    //商品订单信息
    GOODS_ORDER("商品订单信息"),

    ALL("加载全部其他信息");


    OtherInfoOption(String label) {
        this.label = label;
    }

    private String label;

}
