package com.rocogz.syy.order.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 正对会员编号或车牌号：核销次数 管控 规则,该规则数据来源于商户中心系统
 * 例如：1天能核销N次,1小时能核销M次,2个月能核销X次
 * @author zhangmin
 * @date 2020/4/29
 */
@Setter @Getter
public class WriteOffTimesLimitRuleDto {

    /**
     * 类型，就是单位：1:小时  2:天  3:周  4:月
     */
    private Integer type;

    /**
     * 范围数：即数量：根据类型可能是 1小时  2天
     */
    private Integer scope;

    /**
     * 设置的次数 阀值
     * 即会员最近时间内的订单数量不能超过 此设置的值
     */
    private Integer times;

    /**
     * 限制的对象：1:会员编号  2:车牌号 （即按照会员编号统计，还是按照车牌号统计）
     */
    private Integer target;

    @JsonIgnore
    public String getScopeUnit() {
        return this.scope + getUnit();
    }

    @JsonIgnore
    public String getUnit() {
        switch (type) {
            case 1:
                return "小时";
            case 2:
                return "天";
            case 3:
                return "周";
            case 4:
                return "月";
        }
        return "";
    }
    // 计算当前时间之前的某个时间
    @JsonIgnore
    public LocalDateTime getLimitedBeforeDateTime() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime before = null;
        // 小时
        if (1 == type) {
            before = now.minusHours(scope);
        }
        // 天
        else if (2 == type) {
            before = now.minusDays(scope);
        }
        // 周
        else if (3 == type) {
            before = now.minusWeeks(scope);
        }
        // 月
        else if (4 == type) {
            before = now.minusMonths(scope);
        }

        return before;
    }


}
