package com.rocogz.syy.order.dto.peccancy;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.PeccancyConstant;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;

/**
 * 管理后台-> 违章订单 搜索 条件
 * @author zhangmin
 * @date 2020/5/12
 */
@Data
public class PeccancyAdminSearchParamDto extends AdminBaseSearchDto  {

    public PeccancyAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.PECCANCY_ORDER);
    }

    /**
     * 鼎聚订单号
     */
    private String dingjuOrderCode;

    /**
     * 驾驶证号
     */
    private String licenseNumber;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 鼎聚订单状态:(1:预约中；2:办理中；3:办理中；4:已完成；5:已取消；6:已完成；7:已完成)
     * @see PeccancyConstant.DictState
     */
    private String state;

    /**
     * 车辆性质
     */
    private String  carProperty;

}
