package com.rocogz.syy.order.dto.insurancegift;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 投保礼关联
 * </p>
 *
 * @author liangyongtong
 * @since 2020-08-27
 */
@Data
@Accessors(chain = true)
public class MerchantInsuranceGiftDto implements Serializable {


    /**
     * 编码
     */
    private String code;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 关联类型
     */
    private String relateType;

    /**
     * 对应的关联数据编码:商品类型时如果是全部商户则为 *
     */
    private String relateCode;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 销售价
     */
    private BigDecimal settlePrice;

}
