package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 商户投保礼主订单
 * </p>
 *
 * @author liangyongtong
 * @since 2020-08-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_main_order")
public class MerchantInsuranceGiftMainOrder extends IdEntity {

    private static final long serialVersionUID = -1359427746550782744L;
    /**
     * 主订单编号 -> 投保方案编号
     */
    private String code;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 二级订单编码,列表中存放 待支付 待赠送 待领取 对应编码
     */
    @TableField(exist = false)
    private String itemCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 车牌号
     */
    private String license;

    /**
     * 保险公司编码
     */
    private String companyCode;

    /**
     * 费率编码
     */
    private String rateCode;

    /**
     * 保险公司名称（冗余字段）
     */
    private String companyName;

    /**
     * 投保方案状态
     */
    private String status;

    /**
     * 状态的流转状态
     */
    @TableField(exist = false)
    private String currentStatus;

    /**
     * 加投点数
     */
    private BigDecimal addCastPoint;

    /**
     * 加投费用
     */
    private BigDecimal addCastCost;

    /**
     * 商业险
     */
    private BigDecimal commercialInsurance;

    /**
     * 商业险点数
     */
    private BigDecimal commercialInsurancePoint;

    /**
     * 商业险返佣
     */
    private BigDecimal commercialInsuranceCommission;

    /**
     * 交强险
     */
    private BigDecimal interwovenInsurance;

    /**
     * 交强险点数
     */
    private BigDecimal interwovenInsurancePoint;

    /**
     * 交强险返佣
     */
    private BigDecimal interwovenInsuranceCommission;

    /**
     * 膨胀率
     */
    private BigDecimal inflationRate;

    /**
     * 礼品数
     */
    private Integer giftCount;

    /**
     * 总预算
     */
    private BigDecimal totalBudget;

    /**
     * 总保费
     */
    private BigDecimal totalPremium;

    /**
     * 金额 (本单统合情况  = 本单总预算 - 成本总价 [贴 -> 负数][省 -> 正数]
     */
    private BigDecimal preferentialAmount;

    /**
     * 总返佣
     */
    private BigDecimal totalCommission;

    /**
     * 总成本价
     */
    private BigDecimal totalCostPrice;

    /**
     * 更新商户账号
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建商户账号
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建方案的商户openid
     */
    private String createOpenid;

    /**
     * 利用次数
     */
    private Integer copyTime;

    /**
     * 确认时间
     */
    @TableField(exist = false)
    private Long confinTime;

    /**
     * 倒计时间隔
     */
    @TableField(exist = false)
    private long interval;

    /**
     * 是否有商品
     */
    @TableField(exist = false)
    private Boolean hasGood;

    /**
     * 二级订单对象
     */
    @TableField(exist = false)
    private List<MerchantInsuranceGiftItemOrder> itemOrders;


}
