/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public final class AppointUtil {
    static final String HM_PATTERN = "HH:mm";

    private AppointUtil() {
    }

    public static LocalDateTime[] parseStartEndTime(String timeRange) {
        int idx = timeRange.lastIndexOf("-");
        String startTimeStr = timeRange.substring(0, idx);
        String endTimeStr = timeRange.substring(idx + 1, timeRange.length());
        LocalDateTime startTime = LocalDateTime.parse(startTimeStr.trim(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        LocalDateTime endTime = LocalDateTime.of(startTime.toLocalDate(), LocalTime.parse(endTimeStr, DateTimeFormatter.ofPattern(HM_PATTERN)));
        return new LocalDateTime[]{startTime, endTime};
    }

    public static String concatAppointTimeRange(LocalDateTime startTime, LocalDateTime endTime) {
        LocalTime start = startTime.toLocalTime();
        LocalTime end = endTime.toLocalTime();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern(HM_PATTERN);
        String startStr = start.format(pattern);
        String endStr = end.format(pattern);
        return startStr + "-" + endStr;
    }

    public static String concatAppointDateTimeRange(LocalDateTime startTime, LocalDateTime endTime) {
        if (startTime == null || endTime == null) {
            return "";
        }
        String timePart = AppointUtil.concatAppointTimeRange(startTime, endTime);
        String datePart = startTime.toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return datePart + " " + timePart;
    }
}

