package com.rocogz.syy.order.constant;

import java.io.Serializable;

/**
 * 投保礼
 * @author：liangyongtong
 * @since：2020/9/3
 */
public class InsuranceGiftConstant implements Serializable {

    /**
     * 字典表数据
     */
    public class DictData {
        /** 公共的状态 是 */
        public final static String COMMON_STATUS_YES = "Y";
        /** 公共的状态 否 */
        public final static String COMMON_STATUS_NO = "N";

        // 投保礼订单类型
        /** 商户端 */
        public final static String ORDER_TYPE_STORE = "STORE";
        /** 会员端 */
        public final static String ORDER_TYPE_MEMBER = "MEMBER";
        /** 方案 */
        public final static String ORDER_TYPE_PLAN = "PLAN";

        /** 方案类型:普通类型 */
        public final static String ORDER_PLAN_TYPE_COMMON = "COMMON";
        /** 方案类型:代理人定制类型 */
        public final static String ORDER_PLAN_TYPE_AGENT_CUSTOMIZED = "CUSTOMIZED";

        // 设保礼礼品类型
        /** 设保礼礼品类型 套餐 **/
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PACKAGE = "PACKAGE";
        /** 投保礼礼品类型 商品 */
        public static final String MERCHANT_INSURANCE_GIFT_TYPE_GOODS = "GOODS";

        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PROJECT = "PROJECT";

        public final static String MERCHANT_INSURANCE_GIFT_TYPE_COUPON = "COUPON";

        /** 礼品状态： 待发货 */
        public final static String ORDER_ENTITY_STATUS_PENDING_DELIVERY = "PENDING_DELIVERY";
        /** 礼品状态： 待收货*/
        public final static String ORDER_ENTITY_STATUS_DELIVERED = "DELIVERED";
        /** 礼品状态： 已收货*/
        public final static String ORDER_ENTITY_STATUS_RECEIVED = "RECEIVED";
        /** 礼品状态： 未发券*/
        public final static String ORDER_VIRTUAL_STATUS_UNSENT = "UNSENT";
        /** 礼品状态： 已发券*/
        public final static String ORDER_VIRTUAL_STATUS_SENDED = "SENDED";

        // 投保礼订单状态
        /** 报价中 */
//        public final static String INSURANCE_GIFT_INSUREING = "INSUREING";
        /** 处理中 */
//        public final static String INSURANCE_GIFT_PROCESSING = "PROCESSING";
        /** 已完成 */
//        public final static String INSURANCE_GIFT_COMPLETED = "COMPLETED";
        /** 已作废 */
//        public final static String INSURANCE_GIFT_INVALID = "INVALID";
    }

    /**
     * 排序类型
     */
    public class OrderBy {
        /** 智能排序 */
        public final static String AI = "AI";
        /** 预算从低到高 */
        public final static String BUDGETASC = "BUDGETASC";
        /** 预算从高到低 */
        public final static String BUDGETDESC = "BUDGETDESC";

        /** 市场从低到高 */
        public final static String MARKETASC = "MARKETASC";
        /** 市场从高到低 */
        public final static String MARKETDESC = "MARKETDESC";

        /** 成本从低到高 */
        public final static String COSTASC = "COSTASC";
        /** 成本从高到低 */
        public final static String COSTDESC = "COSTDESC";


    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /** 商户投保礼订单编码 **/
        public final static String MERCHANT_INSURANCE_GIFT_ORDER_CODE = "MERCHANT_INSURANCE_GIFT_ORDER_CODE";
    }
}
