package com.rocogz.syy.order.entity.oil;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.order.entity.orders.BaseUserInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子加油券充值成功记录表
 * </p>
 *
 * @author zhangmin
 * @since 2020-05-28
 */
@TableName("order_oil_deposit_record")
@Setter @Getter @Accessors(chain = true)
public class OilDepositRecord extends BaseUserInfo {

    /**
     * 油卡系统交易号/主订单号
     */
    private String tradeNo;

    /**
     * 油卡系统 本次充值业务单号
     */
    private String bizNo;

    /**
     * 本次到账金额
     */
    private BigDecimal bizAmt;

    /**
     * 充值手机号
     */
    private String depositMobile;

    /**
     * 有效期-开始日期
     */
    private LocalDate validStartDate;

    /**
     * 有效期-结束日期
     */
    private LocalDate validEndDate;

    /**
     * 中石化券码
     */
    private String supplierCouponCode;

    /**
     * 本次充值到账时间,即收到接口回调时间
     */
    private LocalDateTime bizTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


    /**
     * 是否全部充值完毕
     */
    private transient Boolean tradeFinished;

}
