package com.rocogz.syy.order.dto.insurancegift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemDetailCombo;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemOrder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 商户投保礼创建订单入参对象
 * @author：liangyongtong
 * @since：2020/8/31
 */
@Data
public class MerchantInsuranceGiftMainOrderAdminDto implements Serializable {

    private static final long serialVersionUID = -1359427746550782744L;
    /**
     * 主订单编号 -> 投保方案编号
     */
    private String code;

    /**
     * 方案编号
     */
    private String itemCode;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 商户名称
     */
    private String storeName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 车牌号
     */
    private String license;

    /**
     * 保险公司编码
     */
    private String companyCode;

    /**
     * 保险公司名称（冗余字段）
     */
    private String companyName;

    /**
     * 投保方案状态
     */
    private String status;

    /**
     * 加投点数
     */
    private BigDecimal addCastPoint;

    /**
     * 加投费用
     */
    private BigDecimal addCastCost;

    /**
     * 商业险
     */
    private BigDecimal commercialInsurance;

    /**
     * 商业险点数
     */
    private BigDecimal commercialInsurancePoint;

    /**
     * 商业险返佣
     */
    private BigDecimal commercialInsuranceCommission;

    /**
     * 交强险
     */
    private BigDecimal interwovenInsurance;

    /**
     * 交强险点数
     */
    private BigDecimal interwovenInsurancePoint;

    /**
     * 交强险返佣
     */
    private BigDecimal interwovenInsuranceCommission;

    /**
     * 礼品数
     */
    private int giftCount;

    /**
     * 礼品数Str
     */
    private String giftCountStr;

    /**
     * 总预算
     */
    private BigDecimal totalBudget;

    /**
     * 总保费
     */
    private BigDecimal totalPremium;

    /**
     * 总返佣
     */
    private BigDecimal totalCommission;

    /**
     * 应付金额
     */
    private BigDecimal amount;

    /**
     * 总市场价
     */
    private BigDecimal totalMarketPrice;

    /**
     * 总成本价
     */
    private BigDecimal totalCostPrice;

    /**
     * 更新商户账号
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建商户账号
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 状态的流转状态
     */
    private String currentStatus;

    /**
     * 方案类型
     */
    private String planType;

    /**
     * 报价次数
     */
    private int coun;

    /**
     * 下单渠道
     */
    private String orderType;

    /**
     * 下单人
     */
    private String userName;

    /**
     * 下单手机
     */
    private String userMobile;

    /**
     * 下单人团队
     */
    private String teamName;

    /**
     * 下单机构
     */
    private String orgName;

    /**
     * 下单代理商
     */
    private String agentName;

    /**
     * 方案市场价Str
     */
    private String totalMarketPriceStr;

    /**
     * 方案成本价Str
     */
    private String totalCostPriceStr;

    /**
     * 方案结算价Str
     */
    private String amountStr;

    /**
     * 方案市场价(最小)
     */
    private BigDecimal marketLeast;

    /**
     * 方案市场价(最大)
     */
    private BigDecimal marketMaximum;

    /**
     * 方案成本价(最小)
     */
    private BigDecimal costLeast;

    /**
     * 方案成本价(最大)
     */
    private BigDecimal costMaximum;

    /**
     * 支付方式
     */
    private String payWay;

    /**
     * 方案模式
     */
    private String planModel;

    /**
     * 方案现金
     */
    private BigDecimal cash;

    /**
     * 方案现金
     */
    private String cashStr;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 预算成本差额
     */
    private String budgetCostDifference;

    /**
     * 处理状态
     */
    private String handleStatus;

    /**
     * 是否确认过
     */
    private Boolean confirmStatus;

}
