package com.rocogz.syy.order.dto.peccancy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrderItem;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 创建违约订单 Dto
 * @author zhangmin
 * @date 2020/5/30
 */
@Setter @Getter @Accessors(chain = true)
public class CreatePeccancyOrderDto extends QueryPeccancyConditionsDto {

    /**
     * 会员手机号 [必传]
     */
    private String mobile;

    /**
     * 会员openid [必传]
     */
    private String openId;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CAR_SERVICE
     */
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    private String channel;

    /**
     * 是否本人本证
     */
    private Boolean self;

    /**
     * 驾驶人名字
     */
    private String driver;

    /**
     * 驾驶证号
     */
    private String licenseNumber;

    /**
     * 驾驶证档案编号
     */
    private String licenseFileNumber;

    /**
     * 驾驶证绑定手机号
     */
    private String licensePhoneNumber;


    //驾驶证 剩余分数
    private Integer scoreBalance;

    @JsonIgnore
    private transient List<OrderPeccancyOrderItem> itemList;
}

