package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-商品订单
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order")
public class GoodsOrder extends IdEntity {

    private static final long serialVersionUID = -6947173409061140577L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 是否虚拟商品
     */
    private Boolean virtualGoods;

    /**
     * 是否是赠送订单
     */
    private Boolean bestow;

    /**
     * 商品编号
     */
    private String goodsCode;

    /**
     * 商品供应商编号
     */
    private String goodsSupplierCode;

    /**
     * 商品供应商名称
     */
    private String goodsSupplierName;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品展示图片url
     */
    private String goodsPictureUrl;

    /**
     * 商品单价
     */
    private BigDecimal goodsUnitPrice;

    /**
     * 商品购买数量
     */
    private Integer goodsAmount;

    /**
     * 商品总价
     */
    private BigDecimal goodsTotalPrice;

    /**
     * 订单总金额(含运费)
     */
    private BigDecimal totalAmount;

    /**
     * 积分已支付总金额
     */
    private BigDecimal pointPayedTotalAmount;

    /**
     * 现金已支付总金额
     */
    private BigDecimal cashPayedTotalAmount;

    /**
     * 快递运输费用
     */
    private BigDecimal transportFeeAmount;

    /**
     * 快递名称
     */
    private String expressDeliveryName;

    /**
     * 快递单号
     */
    private String expressDeliveryNumber;

    /**
     * 发货时间
     */
    private LocalDateTime sendTime;

    /**
     * 确认收货时间
     */
    private LocalDateTime receiveTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 支付方式(POINT:积分; CASH:现金;POINT_AND_CASH:积分+现金)
     * @see com.rocogz.syy.order.constant.OrderConstant.DictGoodsOrderPayWay
     */
    private String payWay;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 下单类型
     */
    private String createType;

    /**
     * 订单收货地址信息
     */
    @TableField(exist = false)
    private GoodsOrderDeliveryAddress goodsOrderDeliveryAddress;

    /**
     * 商品订单赠送信息
     */
    @TableField(exist = false)
    private GoodsOrderBestowInfo goodsOrderBestowInfo;

    /**
     * 商品订单B端代理人信息
     */
    @TableField(exist = false)
    private GoodsOrderAgentUserInfo goodsOrderAgentUserInfo;

    /**
     * 剩余需要现金支付的金额
     */
    @TableField(exist = false)
    private BigDecimal cashNeedPayAmount;
}
