package com.rocogz.syy.order.entity.pay;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-微信支付记录
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-06-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_wx_pay_record")
public class WxPayRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * roco订单编码
     */
    private String rocoTradeNo;

    /**
     * roco订单类型
     */
    private String rocoTradeType;

    /**
     * 记录微信回调之后，我们调用内部接口的返回状态码，用于判断调用内部接口是否成功，可以利用微信的多次回调机制进行重试
     */
    private String rocoResCode;

    /**
     * 记录微信回调之后，我们调用内部接口的次数
     */
    private Integer rocoTryCount;

    /**
     * 收款商户id
     */
    private String mchId;

    /**
     * 小程序appid
     */
    private String appid;

    /**
     * 微信用户openid
     */
    private String wxUserOpenid;

    /**
     * 交易会话标识
     */
    private String wxPrepayId;

    /**
     * 微信支付交易类型
     */
    private String wxTradeType;

    /**
     * 订单总金额(单位为分)
     */
    private Integer wxTotalFee;

    /**
     * 微信支付订单号
     */
    private String wxTransactionId;

    /**
     * 用户支付时使用的银行类型
     */
    private String wxBankType;

    /**
     * 支付完成时间，格式为yyyyMMddHHmmss
     */
    private String wxTimeEnd;

    /**
     * 微信订单支付状态
     */
    private String wxTradeState;

    /**
     * 支付成功回调地址
     */
    private String wxNotifyUrl;

    /**
     * 微信创建支付订单接口返回的业务结果
     */
    private String wxPreResultCode;

    /**
     * 微信支付回调roco传入的业务结果
     */
    private String wxResResultCode;

    /**
     * 微信支付回调roco传入的错误代码
     */
    private String wxResErrCode;

    /**
     * 微信支付回调roco传入的错误代码描述
     */
    private String wxResErrCodeDes;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    @TableField(exist = false)
    private String origin;

    @TableField(exist = false)
    private WxPayRefundRecord wxPayRefundRecord;
}
