package com.rocogz.syy.order.constant;

/**
 * 订单模块 rabbit 消息 消息常量
 * @author zhangmin
 * @date 2020/6/1
 */
public class OrderRabbitConstant {

    /**
     * 订单中心通用Exchange
     */
    public static final String ORDER_EXCHANGE = "ORDER_EXCHANGE";

    /**
     * 创建 油卡交易订单的队列,消息者收到此队列中的消息就调用油卡系统 交易订单创建接口
     */
    public static final String CREATE_OIL_TRADE_ORDER_QUEUE = "ORDER_OIL_TRADE_QUEUE";

    public static final String CREATE_OIL_TRADE_ORDER_EXCHANGE = "ORDER_OIL_TRADE_EXCHANGE";

    public static final String CREATE_OIL_TRADE_ORDER_ROUTE_KEY = "CREATE_OIL_TRADE_ORDER_KEY";


    public static final String CREATE_DINGJU_OIL_TRADE_ORDER_QUEUE = "ORDER_DINGJU_OIL_TRADE_QUEUE";
    public static final String CREATE_DINGJU_OIL_TRADE_ORDER_ROUTE_KEY = "CREATE_DINGJU_OIL_ORDER_KEY";


    /**
     * 油卡订单使用券的情况
     */
    public static final String OIL_ORDER_USED_TICKET_QUEUE = "ORDER_OIL_USED_TICKET_QUEUE";
    public static final String OIL_ORDER_USED_TICKET_ROUTE_KEY = "ORDER_OIL_USED_TICKET_KEY";


    /**
     * 充值结果通知推送的 队列,消息者收到此队列中的消息就保存充值记录
     */
    public static final String DEPOSIT_RECORD_QUEUE = "ORDER_DEPOSIT_RECORD_QUEUE";

    public static final String DEPOSIT_RECORD_EXCHANGE = "ORDER_DEPOSIT_RECORD_EXCHANGE";

    public static final String DEPOSIT_RECORD_ROUTE_KEY = "ORDER_DEPOSIT_RECORD_KEY";




    /**
     * 取消超时没有支付的订单
     */
    public static final String CANCEL_TIME_OUT_EXCHANGE = "ORDER_CANCEL_TIME_OUT_EXCHANGE";

    //延迟队列 即有超时时间的队列
    public static final String CANCEL_TIME_OUT_DELAY_QUEUE = "ORDER_TIMEOUT_DELAY_QUEUE";

    public static final String CANCEL_TIME_OUT_DELAY_ROUTE_KEY = "ORDER_TIMEOUT_DELAY_KEY";

    //存放变成死信的队列
    public static final String CANCEL_TIME_OUT_DEAD_QUEUE = "ORDER_TIMEOUT_DEAD_QUEUE";
    public static final String CANCEL_TIME_OUT_DEAD_ROUTE_KEY = "ORDER_TIMEOUT_DEAD_KEY";






    //=============> 下面是预约订单相关的 rabbit mq 常量


    /**
     * 预约订单 使用的交换机
     */
    public static final String APPOINT_ORDER_EXCHANGE = "ORDER_APPOINT_EXCHANGE";

    public static final String APPOINT_WRITE_OFF_QUEUE = "ORDER_APPOINT_WRITE_OFF_QUEUE";
    public static final String APPOINT_WRITE_OFF_ROUTE_KEY = "APPOINT_WRITE_OFF_KEY";

    public static final String APPOINT_CANCEL_ORDER_QUEUE = "ORDER_APPOINT_CANCEL_QUEUE";
    public static final String APPOINT_CANCEL_ORDER_ROUTE_KEY = "APPOINT_CANCEL_KEY";



    //=============> 下面是违章订单相关的 rabbit mq 常量

    /**
     * 创建鼎聚订单的队列,消息者收到此队列中的消息就 鼎聚接口 创建订单
     */
    public static final String PECCANCY_CREATEE_DINGJU_ORDER_QUEUE = "ORDER_CREATE_DINGJU_ORDER_QUEUE";

    public static final String PECCANCY_DINGJU_ORDER_EXCHANGE = "ORDER_DINGJU_ORDER_EXCHANGE";

    public static final String PECCANCY_CREATE_DINGJU_ORDER_ROUTE_KEY = "CREATE_DINGJU_ORDER_ROUTE_KEY";


    /** =============> 下面是提现订单相关的 rabbit mq 常量 */
    public static final String WITHDRAWALS_ORDER_EXCHANGE = "ORDER_WITHDRAWALS_ORDER_EXCHANGE";

    public static final String WITHDRAWALS_ORDER_QUEEN = "ORDER_WITHDRAWALS_ORDER_QUEEN";

    public static final String WITHDRAWALS_ORDER_ROUTE_KEY = "ORDER_WITHDRAWALS_ORDER_ROUTE_KEY";

    /** =============> 下面是 虚拟商品订单发货队列 rabbit mq 常量 */
    public static final String ORDER_VIRTUAL_GOODS_DELIVERY_EXCHANGE = "ORDER_VIRTUAL_GOODS_DELIVERY_EXCHANGE";
    public static final String ORDER_VIRTUAL_GOODS_DELIVERY_QUEUE = "ORDER_VIRTUAL_GOODS_DELIVERY_QUEUE";
    public static final String ORDER_VIRTUAL_GOODS_DELIVERY_ROUTE_KEY = "GOODS_DELIVERY_ROUTE_KEY";

    /** =============> 下面是 商品下单积分回馈 rabbit mq 常量 */
    public static final String ORDER_GOODS_ORDER_FEEDBACK = "GOODS_ORDER_FEEDBACK_QUEUE";
    public static final String ORDER_GOODS_ORDER_FEEDBACK_ROUTE_KEY = "GOODS_ORDER_FEEDBACK_KEY";
}
