package com.rocogz.syy.order.dto.oil;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 *存电子券兑换：加油电子券 下单Dto,支持多张券合并支付1个订单
 * @author zhangmin
 * @date 2020/5/30
 */
@Setter @Getter @Accessors(chain = true)
public class OilOrderCreateDto extends OilOrderBaseDto {

    /**
     * 会员编号 [必传]
     */
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    private String mobile;

    /**
     * 会员openid [必传]
     */
    private String openId;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CAR_SERVICE
     */
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    private String channel;

    /*
     * 所属平台appId
     */
    private String miniAppid;


    /**
     * 通过管理后台下单时传入此字段[选传]
     */
    private String adminCode;
}
