package com.rocogz.syy.order.entity.peccancy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.util.ArithUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 违章订单中违章信息
 * </p>
 *
 * @author zhangmin
 * @since 2020-07-29
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderPeccancyOrderItem extends IdEntity {

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 违章id
     */
    private String peccancyId;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 监控编号
     */
    private String peccancyNumber;

    /**
     * 违章时间
     */
    private String peccancyAt;

    /**
     * 违章地点
     */
    private String peccancySite;

    /**
     * 违章行为
     */
    private String peccancyAct;

    /**
     * 违法行为
     */
    private String illegalAct;

    /**
     * 违法城市
     */
    private String illegalCity;

    /**
     * 扣分
     */
    private Integer deductedPoints;

    /**
     * 决定书编号
     */
    private String decisionNumber;

    /**
     * 罚款金额
     */
    private BigDecimal fines;

    /**
     * 服务费用，不包含本金， -1代表不可办理
     */
    private BigDecimal poundage;

    /**
     * 违章类型：1电子眼  2现场
     */
    private Integer type;


    /**
     * 本人本证报价, -1不可办理
     */
    private BigDecimal usPriceFirst;


    /**
     * 创建时间
     */
    private LocalDateTime createTime;



    @JsonIgnore
    public BigDecimal getSubTotalAmt() {
        if(usPriceFirst ==null || usPriceFirst.doubleValue()==-1) {
            return this.fines;
        }else {
           return ArithUtil.bigDecimalAdd(this.fines,usPriceFirst);
        }
    }

}
