package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.appoint.OrderAppointment;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.inspection.CarInspectionOrder;
import com.rocogz.syy.order.entity.oil.OrderOilDeposit;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrder;
import com.rocogz.syy.order.entity.withdrawals.WithdrawalsRecord;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单主信息表
 * </p>
 * @author zhangmin
 * @since 2020-04-26
 */
@TableName("order_sale_order")
@Setter @Getter
@Accessors(chain = true)
public class SaleOrder extends BaseUserInfo {

    private static final long serialVersionUID=1L;

    /**
     * 订单类型编号：服务券订单，加油电子券订单，预约订单
     * @see OrderConstant.DictOrderType
     */
    private String orderType;

    /**
     * 下单来源平台编号，如：SYY
     * 该平台码来源于 基础服务系统中：basic_docking_platform表
     */
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用
     * @see OrderConstant.DictChannel
     */
    private String channel;

    /**
     * 所属平台AppId
     */
    private String miniAppid;

    /**
     * 订单状态：处理中,待支付，待使用，待评价，已评价，已取消，已过期
     * @see OrderConstant.DictOrderStatus
     */
    private String status;


    /**
     * 取消订单时间
     */
    private LocalDateTime cancelTime;

    /**
     * 过期时间,该时间来源于用户券
     */
    private LocalDateTime expireTime;

    /**
     * 使用时间，目前与核销时间相同
     */
    private LocalDateTime usedTime;

    /**
     * 是否已被人评价过
     */
    private Boolean evaluated;

    /**
     * 是否被逻辑删除,即是否被会员自己删除了
     */
    private Boolean deleted;

    /**
     * 订单识别码，也就是核销码，例如：42A1AB62BC81727
     * 服务券订单的核销码 可以运行重复，因为一个服务券可以核销多次,生产多个订单
     */
    private String identifyCode;

    /**
     * 业务类型（交互上叫: 发券性质）
     * 2021-01-19 ranxiangfu
     */
    private String serviceType;

    //服务项目信息
    @TableField(exist = false)
    private OrderServiceItem serviceItem;

    //支付单
    @TableField(exist = false)
    private OrderPayment payment;

    //核销信息
    @TableField(exist = false)
    private OrderWriteOff writeOff;

    //结算信息
    @TableField(exist = false)
    private OrderSettlement settlement;


    //电子加油券充值单 [加油电子券订单 专有]
    @TableField(exist = false)
    private OrderOilDeposit deposit;

    //预约信息[预约订单 专有]
    @TableField(exist = false)
    private OrderAppointment appoint;

    //违章订单信息[违章订单 专有]
    @TableField(exist = false)
    private OrderPeccancyOrder peccancy;

    /**
     * 提现订单信息[提现订单 专有]
     */
    @TableField(exist = false)
    private WithdrawalsRecord withdrawalsRecord;

    /**
     * 商品订单信息[商品订单 专有]
     */
    @TableField(exist = false)
    private GoodsOrder goodsOrder;


    /**
     * 车辆年审订单信息
     */
    @TableField(exist = false)
    private CarInspectionOrder carInspectionOrder;

    /**
     *  订单使用优惠券支付的总金额
     */
    @TableField(exist = false)
    private BigDecimal couponAmt;

    /**
     * =====> 以下都是为了页面展示数据用的
     */
    private transient String orderTypeLabel;
    private transient String statusLabel;
    private transient String channelLabel;
    //平台名称
    private transient String platformName;

    //所属小程序平台名字
    private transient String miniAppName;

    /**
     * 该订单是否已核销
     * @return
     */
    @JsonIgnore
    public boolean isWritedOff() {
        return OrderConstant.DictOrderStatus.PENDING_EVALUATE.equals(status) || OrderConstant.DictOrderStatus.EVALUATED.equals(status);
    }

    /**
     * 转化成 ui页面显示的扫描的二维码
     * @param isCentExchangeService
     * @return
     */
    public String convertToIdentifyScanCode(Boolean isCentExchangeService) {
        String prefix = "";
        if(OrderConstant.DictOrderType.APPOINTMENT_ORDER.equals(orderType)) {
            prefix = OrderConstant.APPOINT_ORDER_WRITEOFF_CODE_PREFIX;
        }else if(OrderConstant.DictOrderType.COUPON_ORDER.equals(orderType)) {
            if(isCentExchangeService) {
                prefix = OrderConstant.COUPON_POINT_ORDER_WRITEOFF_CODE_PREFIX;
            }else {
                prefix = OrderConstant.COUPON_ORDER_WRITEOFF_CODE_PREFIX;
            }
        }
        String identifyCode = getIdentifyCode();
        String scanCode = prefix+identifyCode.substring(0, 4) + "-" + identifyCode.substring(4, 8) + "-" + identifyCode.substring(8, 12) + "-" + identifyCode.substring(12, 16);
        return scanCode;
    }
}
