package com.rocogz.syy.order.dto.insurancegift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemDetailCombo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 商户投保礼礼品详情
 * </p>
 *
 * @author liangyongtong
 * @since 2020-08-31
 */
@Data
public class MerchantInsuranceGiftItemDetailCountDTO implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 二级订单号
     */
    private String itemCode;

    /**
     * 方案报价时间
     */
    private LocalDateTime offerTime;

    /**
     * 礼赠说明
     */
    private String remark;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 销售价
     */
    private BigDecimal settlePrice;

    /**
     * 现金
     */
    private BigDecimal cash;

    /**
     * 投保方案状态
     */
    private String status;

    /**
     * 状态的流转状态
     */
    private String currentStatus;

}
