package com.rocogz.syy.order.entity.withdrawals;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-提现费率设置表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_fee_rate_config")
public class WithdrawalsFeeRateConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String userMobile;

    /**
     * 费率
     */
    private BigDecimal feeRate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 公司
     */
    private String company;

    /**
     * 状态(OPEN:启用; LOCK:停用)
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
