package com.rocogz.syy.order.dto.insurancegift;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class MerchantInsuranceGiftItemDetailDTO implements Serializable {

    /**
     * 二级订单号
     */
    private String itemCode;

    /**
     * 关联礼品编码
     */
    private String giftCode;

    /**
     * 关联类型:(套餐|项目|礼品|加油代金券 )
     */
    private String relateType;

    /**
     * 对应的关联数据编码
     */
    private String relateCode;

    /**
     * 对应的关联数据名称
     */
    private String relateName;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 结算价
     */
    private BigDecimal settlePrice;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 前端方案明细颜色变化标志
     */
    private Boolean fontGray = true;

    /**
     * 小计结算价
     */
    private BigDecimal goodsSettlePrice;

    /**
     * 小计结算价Str
     */
    private String goodsSettlePriceStr;

    /**
     * 商品类型几选几中文
     */
    private String goodTypeName;


}
