package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.dto.goods.GoodsOrderExpressDeliveryInfoDto;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 商户投保礼二级订单
 * </p>
 *
 * @author liangyongtong
 * @since 2020-08-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_item_order")
public class MerchantInsuranceGiftItemOrder extends IdEntity {

    private static final long serialVersionUID = -8815073425658511383L;
    /**
     * 主订单编号 -> 投保方案编号
     */
    private String mainCode;

    /**
     * 二级订单编码（主订单编码 + hhmmss）
     */
    private String itemCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 方案类型
     */
    private String planType;

    /**
     * 方案模式
     */
    private String planModel;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 车牌号
     */
    private String license;

    /**
     * 保险公司编码
     */
    private String companyCode;

    /**
     * 费率编码
     */
    private String rateCode;

    /**
     * 保险费率
     */
    private BigDecimal rate;

    /**
     * 保险公司名称（冗余字段）
     */
    private String companyName;

    /**
     * 投保方案状态
     */
    private String status;

    /**
     * 报价商户账号
     */
    private String offerUser;

    /**
     * 报价账号名称
     */
    @TableField(exist = false)
    private String offerUserName;

    /**
     * 方案报价时间
     */
    private LocalDateTime offerTime;

    /**
     * 加投点数
     */
    private BigDecimal addCastPoint;

    /**
     * 加投费用
     */
    private BigDecimal addCastCost;

    /**
     * 保险险费用
     */
    private BigDecimal insurance;

    /**
     * 商业险费用
     */
    private BigDecimal commercialInsurance;

    /**
     * 商业险点数
     */
    private BigDecimal commercialInsurancePoint;

    /**
     * 商业险返佣
     */
    private BigDecimal commercialInsuranceCommission;

    /**
     * 交强险费用
     */
    private BigDecimal interwovenInsurance;

    /**
     * 交强险点数
     */
    private BigDecimal interwovenInsurancePoint;

    /**
     * 交强险返佣
     */
    private BigDecimal interwovenInsuranceCommission;

    /**
     * 礼赠说明
     */
    private String remark;

    /**
     * 总预算
     */
    private BigDecimal totalBudget;

    /**
     * 总保费
     */
    private BigDecimal totalPremium;

    /**
     * 总返佣
     */
    private BigDecimal totalCommission;

    /**
     * 礼品各类数
     */
    private Integer giftTypeNum;

    /**
     * 礼品数
     */
    private Integer giftCount;

    /**
     * 金额 (本单统合情况  = 本单总预算 - 成本总价 [贴 -> 负数][省 -> 正数]
     */
    private BigDecimal preferentialAmount;

    /**
     * 应付金额
     */
    private BigDecimal amount;

    /**
     * 备付金应付金额
     */
    private BigDecimal coverAmount;

    /**
     * 总市场价
     */
    private BigDecimal totalMarketPrice;

    /**
     * 总成本价
     */
    private BigDecimal totalCostPrice;

    /**
     * 状态的流转状态
     */
    private String currentStatus;

    /**
     * 处理状态
     */
    private String handleStatus;

    /**
     * 通知时间
     */
    private LocalDateTime noticeTime;

    /**
     * 确认时间
     */
    private LocalDateTime confirmTime;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;

    /**
     * 赠送时间
     */
    private LocalDateTime sendTime;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 现金
     */
    private BigDecimal cash;

    /**
     * 膨胀率
     */
    private BigDecimal inflationRate;

    /**
     * 赠送编码
     */
    private String bestowCode;

    /**
     * 创建报价单的商户openid
     */
    private String createOpenid;

    /**
     * 利用次数
     */
    private Integer copyTime;

    /**
     * 方案名称
     */
    private String planName;

    /**
     * 套餐性质： 标准套餐 standard、自制套餐 homemade
     */
    private String comboNature;

    /**
     * 来源方案编码
     */
    private String sourcePlanCode;

    /**
     * 确认人员的openid
     */
    private String confirmOpenid;

    /**
     * 支付方式: com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#PAY_WAY_CASH
     * 支付方式: com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#PAY_WAY_COVER
     */
    private String payWay;

    /**
     * 倒计时间隔
     */
    @TableField(exist = false)
    private long interval;

    /**
     * 确认
     */
    @TableField(exist = false)
    private long confirmInvalidInterval;

    /**
     * 是否已加入常用方案:默认没加入
     */
    @TableField(exist = false)
    private boolean joinPlan = false;

    /**
     * 是否有商品
     */
    @TableField(exist = false)
    private Boolean hasGood;

    /**
     * 二级订单对应的礼品列表
     */
    @TableField(exist = false)
    private List<MerchantInsuranceGiftItemDetail> itemDetails;

    /**
     * 预选的商品
     */
    @TableField(exist = false)
    private List<MerchantInsuranceGiftItemGoodReady> goodReadies;

    /**
     * 预选商品统计结果
     */
    @TableField(exist = false)
    private MerchantInsuranceGiftItemGoodStatistics goodStatistics;

    /**
     * 收货地址
     */
    @TableField(exist = false)
    private GoodsOrderDeliveryAddress address;

    /**
     * 发货快递信息
     */
    @TableField(exist = false)
    private List<GoodsOrderExpressDeliveryInfoDto> expressDeliveryList;

    /**
     *  B端下单人信息
     */
    @TableField(exist = false)
    private MerchantInsuranceGiftUser giftUser;

    /**
     * 方案市场价Str
     */
    @TableField(exist = false)
    private String totalMarketPriceStr;

    /**
     * 方案成本价Str
     */
    @TableField(exist = false)
    private String totalCostPriceStr;

    /**
     * 方案结算价Str
     */
    @TableField(exist = false)
    private String amountStr;

    /**
     * 浏览次数
     */
    @TableField(exist = false)
    private int browseNum;

    /**
     * 最近的浏览时间
     */
    @TableField(exist = false)
    private LocalDateTime browseLastest;

    /**
     * 最近浏览人
     */
    @TableField(exist = false)
    private MerchantInsuranceGiftLog lastestBrowse;
}
