package com.rocogz.syy.order.dto.appoint;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

/**
 * 车务平台下单请求Dto, 通过商户编码查询对应的启用了预约状态的商户服务项目
 * @author zhangmin
 * @date 2020/6/1
 */
@Setter @Getter @ToString
public class AppointInfoDto {

    /**
     * 预约人手机号：通过预约手机号 和 车主端小程序绑定的手机号关联 车主端会员编号信息
     */
    private String mobile;

    /**
     * 预约人姓名
     */
    private String name;

    /**
     * 预约车牌号
     */
    private String licenseNo;

    /**
     * roco车服商户编码
     */
    private String storeCode;

    /**
     * 车务平台的主订单号
     */
    private String orderCode;

    /**
     * 订单核销码; 如:ODA6L55849
     * 车务平台 扫码后的识别出来的内容
     */
    private String orderWriteOffCode;

    /**
     * 用户券核销码；如：CSS6W3SV25
     */
    private String userCouponWriteOffCode;

    /**
     * 用户券编码;如: UCP2018092100000005
     */
    private String userCouponCode;


    /**
     * 预约开始时间 例如：2020-07-12 12:20:00
     */
    private LocalDateTime startTime;

    /**
     * 预约结束时间 例如： 例如：2020-07-12 12:50:00
     */
    private LocalDateTime endTime;

}
