package com.rocogz.syy.order.dto.inspection;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author djt
 * @date 2021/1/21
 */
@Data
public class CarInspectionOrderCreateDTO {


    /**
     * 会员编号 [必传]
     */
    @NotBlank
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    @NotBlank
    private String mobile;

    /**
     * 会员openid [必传]
     */
    @NotBlank
    private String openId;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CAR_SERVICE
     */
    @NotBlank
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    @NotBlank
    private String channel;


    /**
     * 小程序appId
     */
    private String miniAppId;


    /**
     * 总金额
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * 微信支付金额
     */
    @NotNull
    private BigDecimal cashAmount;


    /**
     * 用户券信息
     */
    @Valid
    @NotEmpty
    private List<CarInspectionCouponPayItemDTO> carInspectionCouponPayItems;


    /**
     *订单类型
     */
    @NotBlank
    private String inspectionType;


    /**
     * 年审订单信息
     */
    private CarInspectionYearOrderCreateDTO carInspectionYearOrderCreateDTO;

    /**
     * 免检订单信息
     */
    private CarInspectionExemptionCreateDTO carInspectionExemptionCreateDTO;


}
