package com.rocogz.syy.order.dto.insurancegift;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 投保礼汇总
 * @author：liangyongtong
 * @since：2020/9/15
 */
@Data
public class GiftSummaryDto implements Serializable {
    /**
     * 总单数
     */
    private int total;

    /**
     * 成功单数
     */
    private int success;

    /**
     * 成功率
     */
    private BigDecimal successRale;

    /**
     * 总预算
     */
    private BigDecimal totalBudget;

    /**
     * 开单总成本
     */
    private BigDecimal totalCostPrice;

    /**
     * 开单总盈亏
     */
    private BigDecimal preferentialAmount;

    /**
     * 统计时间
     */
    private LocalDateTime statisticsTime;
}
